/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigManager {
    private Configuration config;
    private Property modeProperty;
    private Mode mode = Mode.LIST;
    private double foodHealFactor = 0.5;
    private int foodStackSize = -1;
    private boolean hideHungerBar = true;
    private int hungerBaseline = 10;

    public void setup(File location) {
        this.config = new Configuration(location);
        this.config.load();
        this.syncConfig();
    }

    public void syncConfig() {
        this.modeProperty = this.config.get("general", "Mode", "ALL", null, new String[]{"NONE", "LIST", "ALL"});
        this.modeProperty.setComment("Mode can be set to NONE, LIST, or ALL\n- NONE: Hunger Strike is disabled for all players.\n- LIST: Hunger Strike is enabled for players added\n        in-game with /hungerstrike command.\n- ALL:  Hunger Strike is enabled for all players.");
        Property foodHealProperty = this.config.get("general", "FoodHealFactor", 0.5);
        foodHealProperty.setComment("How to translate food points into heart points when\nconsuming food. At the default value of 0.5, food fills\nyour heart bar at half the rate it would fill hunger.");
        Property foodStackSizeProperty = this.config.get("general", "MaxFoodStackSize", -1).setRequiresMcRestart(true);
        foodStackSizeProperty.setComment("Globally overrides the maximum stack size of food items.\nThis property affects all Vanilla and Mod food items that\nderive from ItemFood.\nSet to -1 to retain the default stack size of each food\nitem.  Note: This will affect the entire server, not just\nplayers on hunger strike.");
        Property hideHungerBarProperty = this.config.get("general", "HideHungerBar", true);
        hideHungerBarProperty.setComment("Controls whether or not the hunger bar is hidden for\nplayers on hunger strike.  If the hunger bar is left\nvisible, it will remain filled at half capacity, except\nwhen certain potion effects are active like hunger and\nregeneration.");
        Property hungerBaselineProperty = this.config.get("general", "HungerBaseline", 10);
        hungerBaselineProperty.setComment("The default hunger level when no status effects are\nactive.  Valid range is [1 - 20], with 20 being fully\nfilled, and 10 being half-filled.  The default value is\n10, which disables health regen but allows sprinting.");
        this.mode = Mode.fromValueIgnoreCase(this.modeProperty.getString());
        this.foodHealFactor = foodHealProperty.getDouble(0.5);
        this.foodStackSize = foodStackSizeProperty.getInt(-1);
        this.hideHungerBar = hideHungerBarProperty.getBoolean(true);
        this.hungerBaseline = hungerBaselineProperty.getInt(10);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public double getFoodHealFactor() {
        return this.foodHealFactor;
    }

    public int getFoodStackSize() {
        return this.foodStackSize;
    }

    public boolean isHungerBarHidden() {
        return this.hideHungerBar;
    }

    public int getHungerBaseline() {
        return this.hungerBaseline;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode value) {
        this.setModeSoft(value);
        this.modeProperty.set(this.mode.toString());
        this.config.save();
    }

    public void setModeSoft(Mode value) {
        this.mode = value;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public static enum Mode {
        NONE,
        LIST,
        ALL;


        public static Mode fromValueIgnoreCase(String value) {
            if (value.compareToIgnoreCase("NONE") == 0) {
                return NONE;
            }
            if (value.compareToIgnoreCase("LIST") == 0) {
                return LIST;
            }
            if (value.compareToIgnoreCase("ALL") == 0) {
                return ALL;
            }
            return LIST;
        }
    }
}

