/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike;

import com.jaquadro.minecraft.hungerstrike.ConfigManager;
import com.jaquadro.minecraft.hungerstrike.ExtendedPlayerHandler;
import com.jaquadro.minecraft.hungerstrike.command.CommandHungerStrike;
import com.jaquadro.minecraft.hungerstrike.proxy.CommonProxy;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

@Mod(modid="hungerstrike", name="Hunger Strike", version="1.9-1.0.6", guiFactory="com.jaquadro.minecraft.hungerstrike.ModGuiFactory", acceptedMinecraftVersions="[1.9,1.11)")
public class HungerStrike {
    public static final String MOD_ID = "hungerstrike";
    static final String MOD_NAME = "Hunger Strike";
    static final String MOD_VERSION = "1.9-1.0.6";
    static final String SOURCE_PATH = "com.jaquadro.minecraft.hungerstrike.";
    @Mod.Instance(value="hungerstrike")
    public static HungerStrike instance;
    @SidedProxy(clientSide="com.jaquadro.minecraft.hungerstrike.proxy.ClientProxy", serverSide="com.jaquadro.minecraft.hungerstrike.proxy.ServerProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper network;
    public static ConfigManager config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        config.setup(event.getSuggestedConfigurationFile());
        ExtendedPlayerHandler.register();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)instance);
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MOD_ID);
        proxy.registerNetworkHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (config.getFoodStackSize() > -1) {
            for (Item item : Item.field_150901_e) {
                if (!(item instanceof ItemFood)) continue;
                item.func_77625_d(config.getFoodStackSize());
            }
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHungerStrike());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            config.syncConfig();
        }
    }

    static {
        config = new ConfigManager();
    }
}

