/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.hungerstrike.command;

import com.jaquadro.minecraft.hungerstrike.ConfigManager;
import com.jaquadro.minecraft.hungerstrike.ExtendedPlayer;
import com.jaquadro.minecraft.hungerstrike.HungerStrike;
import com.jaquadro.minecraft.hungerstrike.PlayerHandler;
import com.jaquadro.minecraft.hungerstrike.network.SyncConfigMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommandHungerStrike
extends CommandBase {
    public int func_82362_a() {
        return 3;
    }

    public String func_71517_b() {
        return "hungerstrike";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.hungerstrike.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1) {
            if (args[0].equals("list")) {
                List<String> players = this.playersToNames(PlayerHandler.getStrikingPlayers(server));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.hungerstrike.list", new Object[]{players.size(), server.func_184103_al().func_181057_v().size()}));
                sender.func_145747_a((ITextComponent)new TextComponentString(CommandHungerStrike.func_71527_a((Object[])players.toArray(new String[players.size()]))));
                return;
            }
            if (args[0].equals("add")) {
                if (args.length < 2) {
                    throw new WrongUsageException("commands.hungerstrike.add.usage", new Object[0]);
                }
                ExtendedPlayer player = ExtendedPlayer.get((EntityPlayer)CommandHungerStrike.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]));
                player.enableHungerStrike(true);
                CommandHungerStrike.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.hungerstrike.add.success", (Object[])new Object[]{args[1]});
                return;
            }
            if (args[0].equals("remove")) {
                if (args.length < 2) {
                    throw new WrongUsageException("commands.hungerstrike.remove.usage", new Object[0]);
                }
                ExtendedPlayer player = ExtendedPlayer.get((EntityPlayer)CommandHungerStrike.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]));
                player.enableHungerStrike(false);
                CommandHungerStrike.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.hungerstrike.remove.success", (Object[])new Object[]{args[1]});
                return;
            }
            if (args[0].equals("mode")) {
                ConfigManager.Mode mode = HungerStrike.config.getMode();
                if (mode == ConfigManager.Mode.NONE) {
                    CommandHungerStrike.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.hungerstrike.mode.none", (Object[])new Object[0]);
                } else if (mode == ConfigManager.Mode.LIST) {
                    CommandHungerStrike.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.hungerstrike.mode.list", (Object[])new Object[0]);
                } else if (mode == ConfigManager.Mode.ALL) {
                    CommandHungerStrike.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.hungerstrike.mode.all", (Object[])new Object[0]);
                }
                return;
            }
            if (args[0].equals("setmode")) {
                if (args.length < 2) {
                    throw new WrongUsageException("commands.hungerstrike.setmode.usage", new Object[0]);
                }
                ConfigManager.Mode mode = ConfigManager.Mode.fromValueIgnoreCase(args[1]);
                HungerStrike.config.setMode(mode);
                if (!sender.func_130014_f_().field_72995_K) {
                    HungerStrike.network.sendToAll((IMessage)new SyncConfigMessage());
                }
                if (mode == ConfigManager.Mode.NONE) {
                    CommandHungerStrike.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.hungerstrike.setmode.none", (Object[])new Object[0]);
                } else if (mode == ConfigManager.Mode.LIST) {
                    CommandHungerStrike.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.hungerstrike.setmode.list", (Object[])new Object[0]);
                } else if (mode == ConfigManager.Mode.ALL) {
                    CommandHungerStrike.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.hungerstrike.setmode.all", (Object[])new Object[0]);
                }
                return;
            }
        }
        throw new WrongUsageException("commands.hungerstrike.usage", new Object[0]);
    }

    public List func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return CommandHungerStrike.func_71530_a((String[])args, (String[])new String[]{"list", "add", "remove", "mode", "setmode"});
        }
        if (args.length == 2) {
            if (args[0].equals("add")) {
                List<String> players = this.playersToNames(PlayerHandler.getNonStrikingPlayers(server));
                return this.getPartialMatches(args[args.length - 1], players);
            }
            if (args[0].equals("remove")) {
                List<String> players = this.playersToNames(PlayerHandler.getStrikingPlayers(server));
                return this.getPartialMatches(args[args.length - 1], players);
            }
            if (args[0].equals("setmode")) {
                return CommandHungerStrike.func_71530_a((String[])args, (String[])new String[]{"none", "list", "all"});
            }
        }
        return null;
    }

    private List<String> playersToNames(List<EntityPlayer> players) {
        ArrayList<String> playerNames = new ArrayList<String>(players.size());
        for (EntityPlayer player : players) {
            playerNames.add(player.func_70005_c_());
        }
        return playerNames;
    }

    private List<String> getPartialMatches(String partialName, List<String> candidates) {
        ArrayList<String> suggestions = new ArrayList<String>();
        for (int i = 0; i < candidates.size(); ++i) {
            String playerName = candidates.get(i);
            if (!CommandHungerStrike.func_71523_a((String)partialName, (String)playerName)) continue;
            suggestions.add(playerName);
        }
        return suggestions;
    }
}

