/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.mimicfish.chest_searcher;

import com.unoriginal.mimicfish.MimicfishClientHandler;
import com.unoriginal.mimicfish.chest_searcher.BlockData;
import com.unoriginal.mimicfish.chest_searcher.BlockInfo;
import com.unoriginal.mimicfish.chest_searcher.BlockStore;
import com.unoriginal.mimicfish.chest_searcher.Controller;
import com.unoriginal.mimicfish.chest_searcher.Render;
import com.unoriginal.mimicfish.chest_searcher.WorldRegion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderEnqueue
implements Runnable {
    private final WorldRegion box;

    public RenderEnqueue(WorldRegion region) {
        this.box = region;
    }

    @Override
    public void run() {
        this.blockFinder();
    }

    private void blockFinder() {
        HashMap<UUID, BlockData> blocks = Controller.getBlockStore().getStore();
        if (blocks.isEmpty()) {
            if (!Render.ores.isEmpty()) {
                Render.ores.clear();
            }
            return;
        }
        WorldClient world = MimicfishClientHandler.mc.field_71441_e;
        ArrayList<BlockInfo> renderQueue = new ArrayList<BlockInfo>();
        for (int chunkX = this.box.minChunkX; chunkX <= this.box.maxChunkX; ++chunkX) {
            int x = chunkX << 4;
            int lowBoundX = x < this.box.minX ? this.box.minX - x : 0;
            int highBoundX = x + 15 > this.box.maxX ? this.box.maxX - x : 15;
            for (int chunkZ = this.box.minChunkZ; chunkZ <= this.box.maxChunkZ; ++chunkZ) {
                if (!world.func_72964_e(chunkX, chunkZ).func_177410_o()) continue;
                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                ExtendedBlockStorage[] extendsList = chunk.func_76587_i();
                int z = chunkZ << 4;
                int lowBoundZ = z < this.box.minZ ? this.box.minZ - z : 0;
                int highBoundZ = z + 15 > this.box.maxZ ? this.box.maxZ - z : 15;
                for (int curExtend = this.box.minChunkY; curExtend <= this.box.maxChunkY; ++curExtend) {
                    ExtendedBlockStorage ebs = extendsList[curExtend];
                    if (ebs == null) continue;
                    int y = curExtend << 4;
                    int lowBoundY = y < this.box.minY ? this.box.minY - y : 0;
                    int highBoundY = y + 15 > this.box.maxY ? this.box.maxY - y : 15;
                    for (int i = lowBoundX; i <= highBoundX; ++i) {
                        for (int j = lowBoundY; j <= highBoundY; ++j) {
                            for (int k = lowBoundZ; k <= highBoundZ; ++k) {
                                BlockStore.BlockDataWithUUID dataWithUUID;
                                ResourceLocation block;
                                IBlockState currentState = ebs.func_177485_a(i, j, k);
                                if (Controller.blackList.contains(currentState.func_177230_c()) || (block = currentState.func_177230_c().getRegistryName()) == null || (dataWithUUID = Controller.getBlockStore().getStoreByReference(block.toString())) == null || dataWithUUID.getBlockData() == null || !dataWithUUID.getBlockData().isDrawing()) continue;
                                double alpha = Math.max(0.0, ((double)Controller.getRadius() - MimicfishClientHandler.mc.field_71439_g.func_70011_f((double)(x + i), (double)(y + j), (double)(z + k))) / (double)Controller.getRadius() * 255.0);
                                renderQueue.add(new BlockInfo(x + i, y + j, z + k, alpha));
                            }
                        }
                    }
                }
            }
        }
        BlockPos playerPos = MimicfishClientHandler.mc.field_71439_g.func_180425_c();
        renderQueue.sort((t, t1) -> Double.compare(t1.func_177951_i((Vec3i)playerPos), t.func_177951_i((Vec3i)playerPos)));
        Render.ores.clear();
        Render.ores.addAll(renderQueue);
    }

    public static void checkBlock(BlockPos pos, IBlockState state, boolean add) {
        if (!Controller.drawOres() || Controller.getBlockStore().getStore().isEmpty()) {
            return;
        }
        String defaultState = state.func_177230_c().func_176223_P().toString();
        if (Controller.getBlockStore().getStore().containsKey(defaultState)) {
            if (!add) {
                Render.ores.remove((Object)new BlockInfo((Vec3i)pos, 0.0));
                return;
            }
            BlockData data = null;
            if (Controller.getBlockStore().getStore().containsKey(defaultState)) {
                data = Controller.getBlockStore().getStore().get(defaultState);
            }
            if (data == null) {
                return;
            }
            double alpha = Math.max(0.0, ((double)Controller.getRadius() - MimicfishClientHandler.mc.field_71439_g.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) / (double)Controller.getRadius() * 255.0);
            Render.ores.add(new BlockInfo((Vec3i)pos, alpha));
        }
    }
}

