/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.mimicfish.world.structure;

import com.unoriginal.mimicfish.world.util.IStructure;
import com.unoriginal.mimicfish.world.util.StructureUtil;
import com.unoriginal.mimicfish.world.util.modRand;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;
import org.apache.logging.log4j.LogManager;

public class WorldGenStructure
extends WorldGenerator
implements IStructure {
    public String structureName;
    protected PlacementSettings placementSettings;
    private static final PlacementSettings DEFAULT_SETTINGS = new PlacementSettings();
    private Template template;
    private float attempts;
    private int maxVar;

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        this.generateStructure(worldIn, position, modRand.choice(Rotation.values()));
        return true;
    }

    public WorldGenStructure(String structureName) {
        this.structureName = structureName;
        this.placementSettings = DEFAULT_SETTINGS.func_186222_a(true).func_186225_a(Blocks.field_150350_a);
    }

    public float getAttempts() {
        return this.attempts;
    }

    private Template getTemplate(World world) {
        if (this.template != null) {
            return this.template;
        }
        MinecraftServer mcServer = world.func_73046_m();
        TemplateManager manager = worldServer.func_184163_y();
        ResourceLocation location = new ResourceLocation("mimicfish", this.structureName);
        this.template = manager.func_189942_b(mcServer, location);
        if (this.template == null) {
            LogManager.getLogger().debug("The template, " + location + " could not be loaded");
            return null;
        }
        return this.template;
    }

    public BlockPos getSize(World world) {
        if (this.getTemplate(world) == null) {
            return BlockPos.field_177992_a;
        }
        return this.template.func_186259_a();
    }

    public int getMaxVariation(World world) {
        if (this.maxVar != 0) {
            return this.maxVar;
        }
        if (this.getTemplate(world) == null) {
            return 0;
        }
        return (int)Math.floor((double)this.template.func_186259_a().func_177956_o() * 0.25);
    }

    public int getYGenHeight(World world, int x, int z) {
        BlockPos templateSize = this.getSize(world);
        return StructureUtil.getAverageGroundHeight(world, x, z, templateSize.func_177958_n(), templateSize.func_177952_p(), this.getMaxVariation(world));
    }

    public void generateStructure(World worldIn, BlockPos pos, Rotation rotation) {
        if (this.getTemplate(worldIn) != null) {
            HashMap<Rotation, BlockPos> rotations = new HashMap<Rotation, BlockPos>();
            rotations.put(Rotation.NONE, new BlockPos(0, 0, 0));
            rotations.put(Rotation.CLOCKWISE_90, new BlockPos(this.template.func_186259_a().func_177958_n() - 1, 0, 0));
            rotations.put(Rotation.COUNTERCLOCKWISE_90, new BlockPos(0, 0, this.template.func_186259_a().func_177952_p() - 1));
            rotations.put(Rotation.CLOCKWISE_180, new BlockPos(this.template.func_186259_a().func_177958_n() - 1, 0, this.template.func_186259_a().func_177952_p() - 1));
            BlockPos rotationOffset = (BlockPos)rotations.get(rotation);
            PlacementSettings rotatedSettings = settings.func_186220_a(rotation);
            BlockPos rotatedPos = pos.func_177971_a((Vec3i)rotationOffset);
            this.template.func_189962_a(worldIn, rotatedPos, rotatedSettings, 18);
            Map dataBlocks = this.template.func_186258_a(rotatedPos, rotatedSettings);
            for (Map.Entry entry : dataBlocks.entrySet()) {
                String s = (String)entry.getValue();
                this.handleDataMarker(s, (BlockPos)entry.getKey(), worldIn, worldIn.field_73012_v);
            }
        }
    }

    protected void handleDataMarker(String function, BlockPos pos, World worldIn, Random rand) {
    }
}

