/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.mimicfish.world.structure;

import com.unoriginal.mimicfish.config.ModConfig;
import com.unoriginal.mimicfish.init.ModItems;
import com.unoriginal.mimicfish.world.structure.WorldGenStructure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenStructures
implements IWorldGenerator {
    private static final ResourceLocation LOOT = new ResourceLocation("mimicfish", "structures/Lunkertooth_Ruins");
    public static final WorldGenStructure OCEAN_RUINS = new WorldGenStructure("ocean/lunkertooth_ruin"){

        @Override
        protected void handleDataMarker(String function, BlockPos pos, World worldIn, Random rand) {
            if (function.equals("loot")) {
                TileEntity tileEntity = worldIn.func_175625_s(pos.func_177977_b());
                worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                if (tileEntity instanceof TileEntityChest) {
                    TileEntityChest chest = (TileEntityChest)tileEntity;
                    chest.func_189404_a(LOOT, rand.nextLong());
                    if (rand.nextInt(3) == 0) {
                        chest.field_145985_p.set(rand.nextInt(chest.field_145985_p.size()), (Object)new ItemStack(ModItems.ANGLERFISH_EGG));
                    }
                    chest.func_184281_d(null);
                }
            }
        }
    };
    public static WorldGenStructure[] listedStructures = new WorldGenStructure[]{OCEAN_RUINS};

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunkX * 16;
        int z = chunkZ * 16;
        Class BIOMES = Biomes.field_76771_b.func_150562_l();
        if (world.field_73011_w.getDimension() == 0) {
            int i = 3;
            if (WorldGenStructures.canStructureSpawn(chunkX, chunkZ, world, ModConfig.ruinsFrequency)) {
                this.generateBiomeSpecificStructure(OCEAN_RUINS, world, random, x, z, BIOMES);
            }
        }
    }

    private boolean generateBiomeSpecificStructure(WorldGenStructure generator, World world, Random rand, int x, int z, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int y = generator.getYGenHeight(world, x += 8, z += 8);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (y > -1 && (world.func_175624_G() != WorldType.field_77138_c || world.field_73011_w.getDimension() != 0) && classesList.contains(biome) && rand.nextFloat() > generator.getAttempts()) {
            generator.func_180709_b(world, rand, pos);
            return true;
        }
        return false;
    }

    public static boolean canStructureSpawn(int chunkX, int chunkZ, World world, int frequency) {
        if (frequency <= 0) {
            return false;
        }
        int realFreq = 11 - frequency;
        int maxDistanceBetween = realFreq + 8;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= maxDistanceBetween - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= maxDistanceBetween - 1;
        }
        int k = chunkX / maxDistanceBetween;
        int l = chunkZ / maxDistanceBetween;
        Random random = world.func_72843_D(k, l, 14357617);
        k *= maxDistanceBetween;
        l *= maxDistanceBetween;
        return i == (k += random.nextInt(maxDistanceBetween - 8)) && j == (l += random.nextInt(maxDistanceBetween - 8));
    }

    public static class lunkerToothStructure
    extends WorldGenStructure {
        public lunkerToothStructure(String structureName) {
            super("structures/" + structureName);
        }
    }
}

