/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.worldgen.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import me.ultrusmods.missingwilds.register.MissingWildsFeatures;
import net.minecraft.class_1299;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3746;
import net.minecraft.class_4481;
import net.minecraft.class_4651;
import net.minecraft.class_4662;
import net.minecraft.class_4663;

public class BranchTreeDecorator
extends class_4662 {
    public static final Codec<BranchTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4651.field_24937.fieldOf("state_provider").forGetter(branchTreeDecorator -> branchTreeDecorator.branchProvider), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("bee_probability").forGetter(branchTreeDecorator -> Float.valueOf(branchTreeDecorator.beeProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("branch_probability").forGetter(branchTreeDecorator -> Float.valueOf(branchTreeDecorator.branchProbability))).apply((Applicative)instance, BranchTreeDecorator::new));
    public final class_4651 branchProvider;
    public final float beeProbability;
    public final float branchProbability;

    public BranchTreeDecorator(class_4651 branchProvider, float beeProbability, float branchProbability) {
        this.branchProvider = branchProvider;
        this.beeProbability = beeProbability;
        this.branchProbability = branchProbability;
    }

    protected class_4663<?> method_28893() {
        return MissingWildsFeatures.BRANCH_TREE;
    }

    public void method_23469(class_3746 world, BiConsumer<class_2338, class_2680> replacer, Random random, List<class_2338> logPositions, List<class_2338> leavesPositions) {
        if (random.nextFloat() >= this.branchProbability) {
            return;
        }
        int maxY = logPositions.get(logPositions.size() - 1).method_10264();
        int minY = logPositions.get(0).method_10264();
        boolean generatedBranch = false;
        for (class_2338 blockPos : logPositions) {
            class_2338 downPos;
            if (generatedBranch) break;
            if (blockPos.method_10264() < (maxY + minY) / 2) continue;
            class_2350 direction = class_2350.method_10139((int)random.nextInt());
            class_2338 checkPos = blockPos.method_10093(direction);
            if (class_3031.method_27370((class_3746)world, (class_2338)checkPos)) {
                class_2680 state = this.branchProvider.method_23455(random, checkPos);
                if (state.method_28498((class_2769)class_2741.field_12496)) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_12496, (Comparable)direction.method_10166());
                }
                generatedBranch = true;
                replacer.accept(checkPos, state);
            }
            if (!class_3031.method_27370((class_3746)world, (class_2338)(downPos = checkPos.method_10074())) || !(random.nextFloat() < this.beeProbability)) continue;
            replacer.accept(downPos, (class_2680)class_2246.field_20421.method_9564().method_11657((class_2769)class_4481.field_20419, (Comparable)direction));
            world.method_35230(downPos, class_2591.field_20431).ifPresent(blockEntity -> {
                int i = 2 + random.nextInt(2);
                for (int j = 0; j < i; ++j) {
                    class_2487 nbtCompound = new class_2487();
                    nbtCompound.method_10582("id", class_2378.field_11145.method_10221((Object)class_1299.field_20346).toString());
                    blockEntity.method_35292(nbtCompound, random.nextInt(599), false);
                }
            });
        }
    }
}

