/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.worldgen.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import me.ultrusmods.missingwilds.block.PolyporeMushroomBlock;
import me.ultrusmods.missingwilds.register.MissingWildsFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class PolyporeMushroomTreeDecorator
extends TreeDecorator {
    public static final Codec<PolyporeMushroomTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("state_provider").forGetter(polyporeMushroomTreeDecorator -> polyporeMushroomTreeDecorator.blockStateProvider), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(polyporeMushroomTreeDecorator -> Float.valueOf(polyporeMushroomTreeDecorator.probability))).apply((Applicative)instance, PolyporeMushroomTreeDecorator::new));
    private final float probability;
    private final BlockStateProvider blockStateProvider;

    public PolyporeMushroomTreeDecorator(BlockStateProvider blockStateProvider, float probability) {
        this.probability = probability;
        this.blockStateProvider = blockStateProvider;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return MissingWildsFeatures.POLYPORE_MUSHROOM.get();
    }

    public void m_142741_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> replacer, Random random, List<BlockPos> logPositions, List<BlockPos> leavesPositions) {
        for (BlockPos blockPos : logPositions) {
            Direction direction;
            BlockPos polyporePos;
            if (!(random.nextFloat() < this.probability) || !Feature.m_65810_((LevelSimulatedReader)world, (BlockPos)(polyporePos = blockPos.m_142300_(direction = Direction.m_122407_((int)random.nextInt()))))) continue;
            BlockState polypore = this.blockStateProvider.m_7112_(random, polyporePos);
            if (polypore.m_61138_((Property)BlockStateProperties.f_61374_)) {
                polypore = (BlockState)polypore.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction);
            }
            if (polypore.m_61138_((Property)PolyporeMushroomBlock.AMOUNT)) {
                polypore = (BlockState)polypore.m_61124_((Property)PolyporeMushroomBlock.AMOUNT, (Comparable)Integer.valueOf(random.nextInt(2) + 1));
            }
            replacer.accept(polyporePos, polypore);
        }
    }
}

