/*
 * Decompiled with CFR 0.152.
 */
package me.ultrusmods.missingwilds.worldgen.feature.tree;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import me.ultrusmods.missingwilds.block.PolyporeMushroomBlock;
import me.ultrusmods.missingwilds.register.MissingWildsFeatures;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class PolyporeMushroomTreeDecorator
extends TreeDecorator {
    public static final Codec<PolyporeMushroomTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("state_provider").forGetter(polyporeMushroomTreeDecorator -> polyporeMushroomTreeDecorator.blockStateProvider), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(polyporeMushroomTreeDecorator -> Float.valueOf(polyporeMushroomTreeDecorator.probability))).apply((Applicative)instance, PolyporeMushroomTreeDecorator::new));
    private final float probability;
    private final BlockStateProvider blockStateProvider;

    public PolyporeMushroomTreeDecorator(BlockStateProvider blockStateProvider, float probability) {
        this.probability = probability;
        this.blockStateProvider = blockStateProvider;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return MissingWildsFeatures.POLYPORE_MUSHROOM.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        RandomSource random = context.m_226067_();
        ObjectArrayList logPositions = context.m_226068_();
        for (BlockPos blockPos : logPositions) {
            Direction direction;
            BlockPos polyporePos;
            if (!(random.m_188501_() < this.probability) || !context.m_226059_(polyporePos = blockPos.m_121945_(direction = Direction.m_122407_((int)random.m_188502_())))) continue;
            BlockState polypore = this.blockStateProvider.m_213972_(random, polyporePos);
            if (polypore.m_61138_((Property)BlockStateProperties.f_61374_)) {
                polypore = (BlockState)polypore.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)direction);
            }
            if (polypore.m_61138_((Property)PolyporeMushroomBlock.AMOUNT)) {
                polypore = (BlockState)polypore.m_61124_((Property)PolyporeMushroomBlock.AMOUNT, (Comparable)Integer.valueOf(random.m_188503_(2) + 1));
            }
            context.m_226061_(polyporePos, polypore);
        }
    }
}

