/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nourishednether.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.nourishednether.world.features.AshSpawner2Feature;
import net.mcreator.nourishednether.world.features.AshSpawnerFeature;
import net.mcreator.nourishednether.world.features.ores.GhostlySoulSludgeFeature;
import net.mcreator.nourishednether.world.features.ores.GlowingObsidianFeature;
import net.mcreator.nourishednether.world.features.ores.SoulSludgeFeature;
import net.mcreator.nourishednether.world.features.plants.GhoulflowerFeature;
import net.mcreator.nourishednether.world.features.plants.SoulWeedsFeature;
import net.mcreator.nourishednether.world.features.plants.WarpedBushFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class NourishedNetherModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"nourished_nether");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> SOUL_SLUDGE = NourishedNetherModFeatures.register("soul_sludge", SoulSludgeFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, SoulSludgeFeature.GENERATE_BIOMES, SoulSludgeFeature::placedFeature));
    public static final RegistryObject<Feature<?>> RICH_SOUL_SLUDGE = NourishedNetherModFeatures.register("rich_soul_sludge", GhostlySoulSludgeFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, GhostlySoulSludgeFeature.GENERATE_BIOMES, GhostlySoulSludgeFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GLOWING_OBSIDIAN = NourishedNetherModFeatures.register("glowing_obsidian", GlowingObsidianFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_ORES, GlowingObsidianFeature.GENERATE_BIOMES, GlowingObsidianFeature::placedFeature));
    public static final RegistryObject<Feature<?>> SOUL_WEEDS = NourishedNetherModFeatures.register("soul_weeds", SoulWeedsFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, SoulWeedsFeature.GENERATE_BIOMES, SoulWeedsFeature::placedFeature));
    public static final RegistryObject<Feature<?>> WARPED_BUSH = NourishedNetherModFeatures.register("warped_bush", WarpedBushFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, WarpedBushFeature.GENERATE_BIOMES, WarpedBushFeature::placedFeature));
    public static final RegistryObject<Feature<?>> GHOULFLOWER = NourishedNetherModFeatures.register("ghoulflower", GhoulflowerFeature::feature, new FeatureRegistration(GenerationStep.Decoration.VEGETAL_DECORATION, GhoulflowerFeature.GENERATE_BIOMES, GhoulflowerFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ASH_SPAWNER = NourishedNetherModFeatures.register("ash_spawner", AshSpawnerFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, AshSpawnerFeature.GENERATE_BIOMES, AshSpawnerFeature::placedFeature));
    public static final RegistryObject<Feature<?>> ASH_SPAWNER_2 = NourishedNetherModFeatures.register("ash_spawner_2", AshSpawner2Feature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, AshSpawner2Feature.GENERATE_BIOMES, AshSpawner2Feature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

