/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.json;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_189;
import net.minecraft.class_1935;
import net.minecraft.class_2105;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_4559;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public final class BuiltinJson {
    private BuiltinJson() {
    }

    public static Result<class_2960, Problem> parseIdentifier(JsonElement element) {
        try {
            return Result.success(new class_2960(element.getJson().getAsString()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid identifier"));
        }
    }

    public static Result<String, Problem> parseIdentifierPath(JsonElement element) {
        try {
            return Result.success(new class_2960("minecraft", element.getJson().getAsString()).method_12832());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid identifier path"));
        }
    }

    public static Result<class_1291, Problem> parseEffect(JsonElement element) {
        return BuiltinJson.parseSomething(class_7923.field_41174, element, () -> "Expected valid effect");
    }

    public static Result<class_6885<class_1291>, Problem> parseEffectTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(class_7923.field_41174, element, () -> "Expected valid effect tag");
    }

    public static Result<class_6885<class_1291>, Problem> parseEffectOrEffectTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(class_7923.field_41174, element, () -> "Expected valid effect or effect tag");
    }

    public static Result<class_2248, Problem> parseBlock(JsonElement element) {
        return BuiltinJson.parseSomething(class_7923.field_41175, element, () -> "Expected valid block");
    }

    public static Result<class_6885<class_2248>, Problem> parseBlockTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(class_7923.field_41175, element, () -> "Expected valid block tag");
    }

    public static Result<class_6885<class_2248>, Problem> parseBlockOrBlockTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(class_7923.field_41175, element, () -> "Expected valid block or block tag");
    }

    public static Result<class_8110, Problem> parseDamageType(JsonElement element, class_5455 manager) {
        return BuiltinJson.parseSomething(manager.method_30530(class_7924.field_42534), element, () -> "Expected valid damage type");
    }

    public static Result<class_6885<class_8110>, Problem> parseDamageTypeTag(JsonElement element, class_5455 manager) {
        return BuiltinJson.parseSomethingTag(manager.method_30530(class_7924.field_42534), element, () -> "Expected valid damage type tag");
    }

    public static Result<class_6885<class_8110>, Problem> parseDamageTypeOrDamageTypeTag(JsonElement element, class_5455 manager) {
        return BuiltinJson.parseSomethingOrSomethingTag(manager.method_30530(class_7924.field_42534), element, () -> "Expected valid damage type or damage type tag");
    }

    public static Result<class_1299<?>, Problem> parseEntityType(JsonElement element) {
        return BuiltinJson.parseSomething(class_7923.field_41177, element, () -> "Expected valid entity type");
    }

    public static Result<class_6885<class_1299<?>>, Problem> parseEntityTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(class_7923.field_41177, element, () -> "Expected valid entity type tag");
    }

    public static Result<class_6885<class_1299<?>>, Problem> parseEntityTypeOrEntityTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(class_7923.field_41177, element, () -> "Expected valid entity type or entity type tag");
    }

    public static Result<class_1792, Problem> parseItem(JsonElement element) {
        return BuiltinJson.parseSomething(class_7923.field_41178, element, () -> "Expected valid item");
    }

    public static Result<class_6885<class_1792>, Problem> parseItemTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(class_7923.field_41178, element, () -> "Expected valid item tag");
    }

    public static Result<class_6885<class_1792>, Problem> parseItemOrItemTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(class_7923.field_41178, element, () -> "Expected valid item or item tag");
    }

    public static Result<class_3448<?>, Problem> parseStatType(JsonElement element) {
        return BuiltinJson.parseSomething(class_7923.field_41193, element, () -> "Expected valid stat type");
    }

    public static Result<class_6885<class_3448<?>>, Problem> parseStatTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(class_7923.field_41193, element, () -> "Expected valid stat type tag");
    }

    public static Result<class_6885<class_3448<?>>, Problem> parseStatTypeOrStatTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(class_7923.field_41193, element, () -> "Expected valid stat type or stat type tag");
    }

    public static Result<class_4559, Problem> parseStatePredicate(JsonElement element) {
        try {
            return Result.success(class_4559.method_22519((com.google.gson.JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid state predicate"));
        }
    }

    public static Result<class_2105, Problem> parseNbtPredicate(JsonElement element) {
        try {
            return Result.success(class_2105.method_9073((com.google.gson.JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid state predicate"));
        }
    }

    public static Result<class_3445<?>, Problem> parseStat(JsonElement element) {
        try {
            return BuiltinJson.parseIdentifier(element).mapSuccess(id -> BuiltinJson.getOrCreateStat((class_3448)class_7923.field_41193.method_17966(class_2960.method_12838((String)id.method_12836(), (char)'.')).orElseThrow(), class_2960.method_12838((String)id.method_12832(), (char)'.')));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid stat"));
        }
    }

    private static <T> class_3445<T> getOrCreateStat(class_3448<T> statType, class_2960 id) {
        return statType.method_14956(statType.method_14959().method_17966(id).orElseThrow());
    }

    public static Result<class_2487, Problem> parseNbt(JsonElement element) {
        try {
            return Result.success(class_2522.method_10718((String)element.getJson().getAsString()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid nbt"));
        }
    }

    public static Result<class_1799, Problem> parseItemStack(JsonElement element) {
        try {
            return element.getAsObject().andThen(object -> {
                ArrayList<Problem> problems = new ArrayList<Problem>();
                Optional item = object.get("item").andThen(BuiltinJson::parseItem).ifFailure(problems::add).getSuccess();
                Optional nbt = object.get("nbt").getSuccess().flatMap(nbtElement -> BuiltinJson.parseNbt(nbtElement).ifFailure(problems::add).getSuccess());
                if (problems.isEmpty()) {
                    class_1799 itemStack = new class_1799((class_1935)item.orElseThrow());
                    nbt.ifPresent(arg_0 -> ((class_1799)itemStack).method_7980(arg_0));
                    return Result.success(itemStack);
                }
                return Result.failure(Problem.combine(problems));
            });
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid item stack"));
        }
    }

    public static Result<class_189, Problem> parseFrame(JsonElement element) {
        try {
            return element.getAsString().andThen(name -> Result.success(class_189.method_833((String)name)));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid frame"));
        }
    }

    public static Result<class_2561, Problem> parseText(JsonElement element) {
        try {
            return Result.success(class_2561.class_2562.method_10872((com.google.gson.JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid text"));
        }
    }

    public static Result<class_1320, Problem> parseAttribute(JsonElement element) {
        try {
            return BuiltinJson.parseIdentifier(element).mapSuccess(id -> {
                if (id.method_12836().equals("puffish_skills")) {
                    id = new class_2960("puffish_attributes", id.method_12832());
                }
                return (class_1320)class_7923.field_41190.method_17966(id).orElseThrow();
            });
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid attribute"));
        }
    }

    public static Result<class_1322.class_1323, Problem> parseAttributeOperation(JsonElement element) {
        return element.getAsString().andThen(string -> switch (string) {
            case "addition" -> Result.success(class_1322.class_1323.field_6328);
            case "multiply_base" -> Result.success(class_1322.class_1323.field_6330);
            case "multiply_total" -> Result.success(class_1322.class_1323.field_6331);
            default -> Result.failure(element.getPath().createProblem("Expected valid attribute operation"));
        });
    }

    private static <T> Result<T, Problem> parseSomething(class_2378<T> registry, JsonElement element, Supplier<String> message) {
        try {
            String string = element.getJson().getAsString();
            return Result.success(registry.method_17966(new class_2960(string)).orElseThrow());
        }
        catch (Exception ignored) {
            return Result.failure(element.getPath().createProblem(message.get()));
        }
    }

    private static <T> Result<class_6885<T>, Problem> parseSomethingTag(class_2378<T> registry, JsonElement element, Supplier<String> message) {
        try {
            String string = element.getJson().getAsString();
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            return Result.success((class_6885)registry.method_46771().method_46733(class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)new class_2960(string))).orElseThrow());
        }
        catch (Exception ignored) {
            return Result.failure(element.getPath().createProblem(message.get()));
        }
    }

    private static <T> Result<class_6885<T>, Problem> parseSomethingOrSomethingTag(class_2378<T> registry, JsonElement element, Supplier<String> message) {
        try {
            String string = element.getJson().getAsString();
            if (string.startsWith("#")) {
                return Result.success((class_6885)registry.method_46771().method_46733(class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)new class_2960(string.substring(1)))).orElseThrow());
            }
            return Result.success(class_6885.method_40246((class_6880[])new class_6880[]{(class_6880)registry.method_40264(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)new class_2960(string))).orElseThrow()}));
        }
        catch (Exception ignored) {
            return Result.failure(element.getPath().createProblem(message.get()));
        }
    }
}

