/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.experience;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_2960;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.experience.source.ExperienceSourceRegistry;
import net.puffish.skillsmod.impl.experience.source.ExperienceSourceConfigContextImpl;
import net.puffish.skillsmod.impl.experience.source.ExperienceSourceDisposeContextImpl;
import net.puffish.skillsmod.util.DisposeContext;

public class ExperienceSourceConfig {
    private final class_2960 type;
    private final ExperienceSource instance;

    private ExperienceSourceConfig(class_2960 type, ExperienceSource instance) {
        this.type = type;
        this.instance = instance;
    }

    public static Result<ExperienceSourceConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> ExperienceSourceConfig.parse(rootObject, context));
    }

    public static Result<ExperienceSourceConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<JsonElement> optTypeElement = rootObject.get("type").ifFailure(problems::add).getSuccess();
        Optional optType = optTypeElement.flatMap(typeElement -> BuiltinJson.parseIdentifier(typeElement).ifFailure(problems::add).getSuccess());
        Result<JsonElement, Problem> maybeDataElement = rootObject.get("data");
        if (problems.isEmpty()) {
            return ExperienceSourceConfig.build((class_2960)optType.orElseThrow(), maybeDataElement, optTypeElement.orElseThrow().getPath(), context);
        }
        return Result.failure(Problem.combine(problems));
    }

    private static Result<ExperienceSourceConfig, Problem> build(class_2960 type, Result<JsonElement, Problem> maybeDataElement, JsonPath typeElementPath, ConfigContext context) {
        return ExperienceSourceRegistry.getFactory(type).map(factory -> factory.create(new ExperienceSourceConfigContextImpl(context, maybeDataElement)).mapSuccess(instance -> new ExperienceSourceConfig(type, (ExperienceSource)instance))).orElseGet(() -> Result.failure(typeElementPath.createProblem("Expected a valid source type")));
    }

    public void dispose(DisposeContext context) {
        this.instance.dispose(new ExperienceSourceDisposeContextImpl(context));
    }

    public class_2960 getType() {
        return this.type;
    }

    public ExperienceSource getInstance() {
        return this.instance;
    }
}

