/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.puffish.skillsmod.api.json.JsonArray;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.impl.json.JsonElementImpl;
import net.puffish.skillsmod.util.JsonPathFailure;

public class JsonObjectImpl
implements net.puffish.skillsmod.api.json.JsonObject {
    private final JsonObject json;
    protected final JsonPath path;

    public JsonObjectImpl(JsonObject json, JsonPath path) {
        this.json = json;
        this.path = path;
    }

    @Override
    public Result<net.puffish.skillsmod.api.json.JsonElement, Problem> get(String key) {
        JsonPath newPath = this.path.getObject(key);
        JsonElement element = this.json.get(key);
        if (element == null) {
            return Result.failure(JsonPathFailure.expectedToExist(newPath));
        }
        return Result.success(new JsonElementImpl(element, newPath));
    }

    @Override
    public Result<net.puffish.skillsmod.api.json.JsonObject, Problem> getObject(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "an object")).andThen(net.puffish.skillsmod.api.json.JsonElement::getAsObject);
    }

    @Override
    public Result<JsonArray, Problem> getArray(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "an array")).andThen(net.puffish.skillsmod.api.json.JsonElement::getAsArray);
    }

    @Override
    public Result<String, Problem> getString(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "a string")).andThen(net.puffish.skillsmod.api.json.JsonElement::getAsString);
    }

    @Override
    public Result<Float, Problem> getFloat(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "a float")).andThen(net.puffish.skillsmod.api.json.JsonElement::getAsFloat);
    }

    @Override
    public Result<Double, Problem> getDouble(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "a double")).andThen(net.puffish.skillsmod.api.json.JsonElement::getAsDouble);
    }

    @Override
    public Result<Integer, Problem> getInt(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "an int")).andThen(net.puffish.skillsmod.api.json.JsonElement::getAsInt);
    }

    @Override
    public Result<Boolean, Problem> getBoolean(String key) {
        return this.get(key).mapFailure(e -> JsonPathFailure.expectedToExistAndBe(this.path.getObject(key), "a boolean")).andThen(net.puffish.skillsmod.api.json.JsonElement::getAsBoolean);
    }

    @Override
    public Stream<Map.Entry<String, net.puffish.skillsmod.api.json.JsonElement>> stream() {
        return this.json.asMap().entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), new JsonElementImpl((JsonElement)entry.getValue(), this.path.getObject((String)entry.getKey()))));
    }

    @Override
    public <S, F> Result<Map<String, S>, Map<String, F>> getAsMap(BiFunction<String, net.puffish.skillsmod.api.json.JsonElement, Result<S, F>> function) {
        HashMap successes = new HashMap();
        HashMap failures = new HashMap();
        this.json.asMap().forEach((key, value) -> ((Result)function.apply((String)key, new JsonElementImpl((JsonElement)value, this.path.getObject((String)key)))).ifSuccess(t -> successes.put(key, t)).ifFailure(t -> failures.put(key, t)));
        if (failures.isEmpty()) {
            return Result.success(successes);
        }
        return Result.failure(failures);
    }

    @Override
    public JsonObject getJson() {
        return this.json;
    }

    @Override
    public JsonPath getPath() {
        return this.path;
    }
}

