/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.calculation.operation.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.damagesource.DamageType;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.operation.OperationConfigContext;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public final class DamageTypeCondition
implements Operation<DamageType, Boolean> {
    private final HolderSet<DamageType> damageTypeEntries;

    private DamageTypeCondition(HolderSet<DamageType> damageTypeEntries) {
        this.damageTypeEntries = damageTypeEntries;
    }

    public static void register() {
        BuiltinPrototypes.DAMAGE_TYPE.registerOperation(SkillsMod.createIdentifier("test"), BuiltinPrototypes.BOOLEAN, DamageTypeCondition::parse);
    }

    public static Result<DamageTypeCondition, Problem> parse(OperationConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen((? super S rootObject) -> DamageTypeCondition.parse(rootObject, context));
    }

    public static Result<DamageTypeCondition, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optDamageType = rootObject.get("damage").orElse(problem -> rootObject.get("damage_type")).andThen((? super S damageElement) -> BuiltinJson.parseDamageTypeOrDamageTypeTag(damageElement, (RegistryAccess)context.getServer().m_206579_())).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new DamageTypeCondition((HolderSet<DamageType>)((HolderSet)optDamageType.orElseThrow())));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public Optional<Boolean> apply(DamageType damageType) {
        return Optional.of(this.damageTypeEntries.m_203614_().anyMatch(entry -> entry.m_203334_() == damageType));
    }
}

