/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClientIconConfig {

    public record TextureIconConfig(ResourceLocation texture) implements ClientIconConfig
    {
        public static Result<TextureIconConfig, Problem> parse(JsonElement rootElement) {
            return rootElement.getAsObject().andThen(rootObject -> rootObject.get("texture")).andThen(BuiltinJson::parseIdentifier).mapSuccess(TextureIconConfig::new);
        }

        public static TextureIconConfig createMissing() {
            return new TextureIconConfig(TextureManager.f_118466_);
        }
    }

    public record EffectIconConfig(MobEffect effect) implements ClientIconConfig
    {
        public static Result<EffectIconConfig, Problem> parse(JsonElement rootElement) {
            return rootElement.getAsObject().andThen(rootObject -> rootObject.get("effect")).andThen(BuiltinJson::parseEffect).mapSuccess(EffectIconConfig::new);
        }
    }

    public record ItemIconConfig(ItemStack item) implements ClientIconConfig
    {
        public static Result<ItemIconConfig, Problem> parse(JsonElement rootElement) {
            return BuiltinJson.parseItemStack(rootElement).mapSuccess(ItemIconConfig::new);
        }
    }
}

