/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config.colors;

import java.util.ArrayList;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.client.config.colors.ClientColorConfig;
import net.puffish.skillsmod.client.config.colors.ClientConnectionsColorsConfig;
import net.puffish.skillsmod.client.config.colors.ClientFillStrokeColorsConfig;

public record ClientColorsConfig(ClientConnectionsColorsConfig connections, ClientFillStrokeColorsConfig points) {
    private static final ClientFillStrokeColorsConfig DEFAULT_POINTS = new ClientFillStrokeColorsConfig(new ClientColorConfig(-8323296), new ClientColorConfig(-16777216));

    public static ClientColorsConfig createDefault() {
        return ClientColorsConfig.parse(JsonElement.parseString("{}", JsonPath.create("Client Colors Default")).getSuccess().orElseThrow()).getSuccess().orElseThrow();
    }

    public static Result<ClientColorsConfig, Problem> parse(JsonElement rootElement) {
        return rootElement.getAsObject().andThen(ClientColorsConfig::parse);
    }

    private static Result<ClientColorsConfig, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        ClientConnectionsColorsConfig connections = rootObject.get("connections").getSuccess().flatMap(element -> ClientConnectionsColorsConfig.parse(element).ifFailure(problems::add).getSuccess()).orElseGet(ClientConnectionsColorsConfig::createDefault);
        ClientFillStrokeColorsConfig points = rootObject.get("points").getSuccess().flatMap(element -> ClientFillStrokeColorsConfig.parse(element, DEFAULT_POINTS).ifFailure(problems::add).getSuccess()).orElse(DEFAULT_POINTS);
        if (problems.isEmpty()) {
            return Result.success(new ClientColorsConfig(connections, points));
        }
        return Result.failure(Problem.combine(problems));
    }
}

