/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config.colors;

import java.util.ArrayList;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.client.config.colors.ClientColorConfig;
import net.puffish.skillsmod.client.config.colors.ClientFillStrokeColorsConfig;

public record ClientConnectionsColorsConfig(ClientFillStrokeColorsConfig locked, ClientFillStrokeColorsConfig available, ClientFillStrokeColorsConfig affordable, ClientFillStrokeColorsConfig unlocked, ClientFillStrokeColorsConfig excluded) {
    private static final ClientFillStrokeColorsConfig DEFAULT_LOCKED = new ClientFillStrokeColorsConfig(new ClientColorConfig(-1), new ClientColorConfig(-16777216));
    private static final ClientFillStrokeColorsConfig DEFAULT_AVAILABLE_AFFORDABLE = new ClientFillStrokeColorsConfig(new ClientColorConfig(-1), new ClientColorConfig(-16777216));
    private static final ClientFillStrokeColorsConfig DEFAULT_UNLOCKED = new ClientFillStrokeColorsConfig(new ClientColorConfig(-1), new ClientColorConfig(-16777216));
    private static final ClientFillStrokeColorsConfig DEFAULT_EXCLUDED = new ClientFillStrokeColorsConfig(new ClientColorConfig(-65536), new ClientColorConfig(-16777216));

    public static ClientConnectionsColorsConfig createDefault() {
        return new ClientConnectionsColorsConfig(DEFAULT_LOCKED, DEFAULT_AVAILABLE_AFFORDABLE, DEFAULT_AVAILABLE_AFFORDABLE, DEFAULT_UNLOCKED, DEFAULT_EXCLUDED);
    }

    public static Result<ClientConnectionsColorsConfig, Problem> parse(JsonElement rootElement) {
        return rootElement.getAsObject().andThen(ClientConnectionsColorsConfig::parse);
    }

    private static Result<ClientConnectionsColorsConfig, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        ClientFillStrokeColorsConfig locked = rootObject.get("locked").getSuccess().flatMap(element -> ClientFillStrokeColorsConfig.parse(element, DEFAULT_LOCKED).ifFailure(problems::add).getSuccess()).orElse(DEFAULT_LOCKED);
        ClientFillStrokeColorsConfig available = rootObject.get("available").getSuccess().flatMap(element -> ClientFillStrokeColorsConfig.parse(element, DEFAULT_AVAILABLE_AFFORDABLE).ifFailure(problems::add).getSuccess()).orElse(DEFAULT_AVAILABLE_AFFORDABLE);
        ClientFillStrokeColorsConfig affordable = rootObject.get("affordable").getSuccess().flatMap(element -> ClientFillStrokeColorsConfig.parse(element, DEFAULT_AVAILABLE_AFFORDABLE).ifFailure(problems::add).getSuccess()).orElse(available);
        ClientFillStrokeColorsConfig unlocked = rootObject.get("unlocked").getSuccess().flatMap(element -> ClientFillStrokeColorsConfig.parse(element, DEFAULT_UNLOCKED).ifFailure(problems::add).getSuccess()).orElse(DEFAULT_UNLOCKED);
        ClientFillStrokeColorsConfig excluded = rootObject.get("excluded").getSuccess().flatMap(element -> ClientFillStrokeColorsConfig.parse(element, DEFAULT_EXCLUDED).ifFailure(problems::add).getSuccess()).orElse(DEFAULT_EXCLUDED);
        if (problems.isEmpty()) {
            return Result.success(new ClientConnectionsColorsConfig(locked, available, affordable, unlocked, excluded));
        }
        return Result.failure(Problem.combine(problems));
    }
}

