/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.network.packets.in;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.client.config.ClientBackgroundConfig;
import net.puffish.skillsmod.client.config.ClientCategoryConfig;
import net.puffish.skillsmod.client.config.ClientFrameConfig;
import net.puffish.skillsmod.client.config.ClientIconConfig;
import net.puffish.skillsmod.client.config.colors.ClientColorsConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillConnectionConfig;
import net.puffish.skillsmod.client.config.skill.ClientSkillDefinitionConfig;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.network.InPacket;

public class ShowCategoryInPacket
implements InPacket {
    private final ClientCategoryData category;

    private ShowCategoryInPacket(ClientCategoryData category) {
        this.category = category;
    }

    public static ShowCategoryInPacket read(FriendlyByteBuf buf) {
        ClientCategoryData category = ShowCategoryInPacket.readCategory(buf);
        return new ShowCategoryInPacket(category);
    }

    public static ClientCategoryData readCategory(FriendlyByteBuf buf) {
        ResourceLocation id = buf.m_130281_();
        Component title = buf.m_130238_();
        ClientIconConfig icon = ShowCategoryInPacket.readSkillIcon(buf);
        ClientBackgroundConfig background = ShowCategoryInPacket.readBackground(buf);
        ClientColorsConfig colors = ShowCategoryInPacket.readColors(buf);
        boolean exclusiveRoot = buf.readBoolean();
        int spentPointsLimit = buf.readInt();
        Map<String, ClientSkillDefinitionConfig> definitions = buf.m_236845_(ShowCategoryInPacket::readDefinition).stream().collect(Collectors.toMap(ClientSkillDefinitionConfig::id, definition -> definition));
        Map<String, ClientSkillConfig> skills = buf.m_236845_(ShowCategoryInPacket::readSkill).stream().collect(Collectors.toMap(ClientSkillConfig::id, skill -> skill));
        List normalConnections = buf.m_236845_(ShowCategoryInPacket::readSkillConnection);
        List exclusiveConnections = buf.m_236845_(ShowCategoryInPacket::readSkillConnection);
        Map skillsStates = buf.m_236847_(FriendlyByteBuf::m_130277_, buf1 -> (Skill.State)buf1.m_130066_(Skill.State.class));
        int spentPoints = buf.readInt();
        int earnedPoints = buf.readInt();
        int currentLevel = Integer.MIN_VALUE;
        int currentExperience = Integer.MIN_VALUE;
        int requiredExperience = Integer.MIN_VALUE;
        if (buf.readBoolean()) {
            currentLevel = buf.readInt();
            currentExperience = buf.readInt();
            requiredExperience = buf.readInt();
        }
        ClientCategoryConfig category = new ClientCategoryConfig(id, title, icon, background, colors, exclusiveRoot, spentPointsLimit, definitions, skills, normalConnections, exclusiveConnections);
        return new ClientCategoryData(category, skillsStates, spentPoints, earnedPoints, currentLevel, currentExperience, requiredExperience);
    }

    public static ClientSkillDefinitionConfig readDefinition(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        Component title = buf.m_130238_();
        Component description = buf.m_130238_();
        Component extraDescription = buf.m_130238_();
        ClientFrameConfig frame = ShowCategoryInPacket.readFrameIcon(buf);
        ClientIconConfig icon = ShowCategoryInPacket.readSkillIcon(buf);
        float size = buf.readFloat();
        int cost = buf.readInt();
        int requiredSkills = buf.readInt();
        int requiredPoints = buf.readInt();
        int requiredSpentPoints = buf.readInt();
        return new ClientSkillDefinitionConfig(id, title, description, extraDescription, icon, frame, size, cost, requiredSkills, requiredPoints, requiredSpentPoints);
    }

    public static ClientIconConfig readSkillIcon(FriendlyByteBuf buf) {
        String type = buf.m_130277_();
        return (ClientIconConfig)((Object)buf.m_236860_(FriendlyByteBuf::m_130277_).flatMap(data -> JsonElement.parseString(data, JsonPath.create("Client Skill Icon")).getSuccess()).flatMap(rootElement -> switch (type) {
            case "item" -> ClientIconConfig.ItemIconConfig.parse(rootElement).getSuccess();
            case "effect" -> ClientIconConfig.EffectIconConfig.parse(rootElement).getSuccess();
            case "texture" -> ClientIconConfig.TextureIconConfig.parse(rootElement).getSuccess();
            default -> Optional.empty();
        }).orElseGet(ClientIconConfig.TextureIconConfig::createMissing));
    }

    public static ClientFrameConfig readFrameIcon(FriendlyByteBuf buf) {
        String type = buf.m_130277_();
        return (ClientFrameConfig)((Object)buf.m_236860_(FriendlyByteBuf::m_130277_).flatMap(data -> JsonElement.parseString(data, JsonPath.create("Client Frame Icon")).getSuccess()).flatMap(rootElement -> switch (type) {
            case "advancement" -> ClientFrameConfig.AdvancementFrameConfig.parse(rootElement).getSuccess();
            case "texture" -> ClientFrameConfig.TextureFrameConfig.parse(rootElement).getSuccess();
            default -> Optional.empty();
        }).orElseGet(ClientFrameConfig.TextureFrameConfig::createMissing));
    }

    public static ClientBackgroundConfig readBackground(FriendlyByteBuf buf) {
        return buf.m_236860_(FriendlyByteBuf::m_130277_).flatMap(data -> JsonElement.parseString(data, JsonPath.create("Client Background")).getSuccess()).flatMap(rootElement -> ClientBackgroundConfig.parse(rootElement).getSuccess()).orElseGet(ClientBackgroundConfig::createMissing);
    }

    public static ClientColorsConfig readColors(FriendlyByteBuf buf) {
        return buf.m_236860_(FriendlyByteBuf::m_130277_).flatMap(data -> JsonElement.parseString(data, JsonPath.create("Client Colors")).getSuccess()).flatMap(rootElement -> ClientColorsConfig.parse(rootElement).getSuccess()).orElseGet(ClientColorsConfig::createDefault);
    }

    public static ClientSkillConfig readSkill(FriendlyByteBuf buf) {
        String id = buf.m_130277_();
        int x = buf.readInt();
        int y = buf.readInt();
        String definition = buf.m_130277_();
        boolean isRoot = buf.readBoolean();
        return new ClientSkillConfig(id, x, y, definition, isRoot);
    }

    public static ClientSkillConnectionConfig readSkillConnection(FriendlyByteBuf buf) {
        String skillAId = buf.m_130277_();
        String skillBId = buf.m_130277_();
        boolean bidirectional = buf.readBoolean();
        return new ClientSkillConnectionConfig(skillAId, skillBId, bidirectional);
    }

    public ClientCategoryData getCategory() {
        return this.category;
    }
}

