/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.FrameType;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public class FrameConfig {
    private final String type;
    private final JsonElement data;

    private FrameConfig(String type, JsonElement data) {
        this.type = type;
        this.data = data;
    }

    public static FrameConfig fromAdvancementFrame(FrameType frame) {
        JsonObject data = new JsonObject();
        data.addProperty("frame", frame.m_15548_());
        return new FrameConfig("advancement", (JsonElement)data);
    }

    public static Result<FrameConfig, Problem> parse(net.puffish.skillsmod.api.json.JsonElement rootElement) {
        return rootElement.getAsObject().andThen(FrameConfig::parse);
    }

    public static Result<FrameConfig, Problem> parse(net.puffish.skillsmod.api.json.JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<String> type = rootObject.getString("type").ifFailure(problems::add).getSuccess();
        Optional<net.puffish.skillsmod.api.json.JsonElement> data = rootObject.get("data").ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new FrameConfig(type.orElseThrow(), data.orElseThrow().getJson()));
        }
        return Result.failure(Problem.combine(problems));
    }

    public String getType() {
        return this.type;
    }

    public JsonElement getData() {
        return this.data;
    }
}

