/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.experience;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.config.experience.ExperiencePerLevelConfig;
import net.puffish.skillsmod.config.experience.ExperienceSourceConfig;
import net.puffish.skillsmod.util.DisposeContext;

public class ExperienceConfig {
    private final ExperiencePerLevelConfig experiencePerLevel;
    private final List<ExperienceSourceConfig> experienceSources;

    private ExperienceConfig(ExperiencePerLevelConfig experiencePerLevel, List<ExperienceSourceConfig> experienceSources) {
        this.experiencePerLevel = experiencePerLevel;
        this.experienceSources = experienceSources;
    }

    public static Result<Optional<ExperienceConfig>, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> ExperienceConfig.parse(rootObject, context));
    }

    public static Result<Optional<ExperienceConfig>, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Boolean enabled = rootObject.getBoolean("enabled").getSuccess().orElse(true);
        Optional optExperiencePerLevel = rootObject.get("experience_per_level").andThen(ExperiencePerLevelConfig::parse).ifFailure(problems::add).getSuccess();
        List experienceSources = rootObject.getArray("sources").andThen(array -> array.getAsList((i, element) -> ExperienceSourceConfig.parse(element, context)).mapFailure(Problem::combine)).ifFailure(problems::add).getSuccess().orElseGet(List::of);
        if (problems.isEmpty()) {
            if (enabled.booleanValue()) {
                return Result.success(Optional.of(new ExperienceConfig((ExperiencePerLevelConfig)optExperiencePerLevel.orElseThrow(), experienceSources)));
            }
            return Result.success(Optional.empty());
        }
        return Result.failure(Problem.combine(problems));
    }

    public int getRequiredExperience(int level) {
        return this.experiencePerLevel.getFunction().apply(level);
    }

    public int getRequiredTotalExperience(int level) {
        int total = 0;
        for (int i = 0; i < level; ++i) {
            total += this.getRequiredExperience(level);
        }
        return total;
    }

    public int getCurrentExperience(int earnedExperience) {
        int level = 0;
        int requiredExperience;
        while (earnedExperience >= (requiredExperience = this.getRequiredExperience(level))) {
            earnedExperience -= requiredExperience;
            ++level;
        }
        return earnedExperience;
    }

    public int getCurrentLevel(int earnedExperience) {
        int level = 0;
        int requiredExperience;
        while (earnedExperience >= (requiredExperience = this.getRequiredExperience(level))) {
            earnedExperience -= requiredExperience;
            ++level;
        }
        return level;
    }

    public void dispose(DisposeContext context) {
        for (ExperienceSourceConfig experienceSource : this.experienceSources) {
            experienceSource.dispose(context);
        }
    }

    public ExperiencePerLevelConfig getExperiencePerLevel() {
        return this.experiencePerLevel;
    }

    public List<ExperienceSourceConfig> getExperienceSources() {
        return this.experienceSources;
    }
}

