/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config.skill;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.impl.rewards.RewardConfigContextImpl;
import net.puffish.skillsmod.impl.rewards.RewardDisposeContextImpl;
import net.puffish.skillsmod.reward.RewardRegistry;
import net.puffish.skillsmod.reward.builtin.DummyReward;
import net.puffish.skillsmod.util.DisposeContext;

public class SkillRewardConfig {
    private final ResourceLocation type;
    private final Reward instance;

    private SkillRewardConfig(ResourceLocation type, Reward instance) {
        this.type = type;
        this.instance = instance;
    }

    public static Result<SkillRewardConfig, Problem> parse(JsonElement rootElement, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> SkillRewardConfig.parse(rootObject, context));
    }

    public static Result<SkillRewardConfig, Problem> parse(JsonObject rootObject, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<JsonElement> optTypeElement = rootObject.get("type").ifFailure(problems::add).getSuccess();
        Optional optType = optTypeElement.flatMap(typeElement -> BuiltinJson.parseIdentifier(typeElement).ifFailure(problems::add).getSuccess());
        Result<JsonElement, Problem> maybeDataElement = rootObject.get("data");
        Boolean required = rootObject.getBoolean("required").getSuccessOrElse(e -> true);
        if (problems.isEmpty()) {
            return SkillRewardConfig.build((ResourceLocation)optType.orElseThrow(), maybeDataElement, rootObject.getPath().getObject("type"), context).orElse(problem -> {
                if (required.booleanValue()) {
                    return Result.failure(problem);
                }
                context.emitWarning(problem.toString());
                return Result.success(new SkillRewardConfig(DummyReward.ID, new DummyReward()));
            });
        }
        return Result.failure(Problem.combine(problems));
    }

    private static Result<SkillRewardConfig, Problem> build(ResourceLocation type, Result<JsonElement, Problem> maybeDataElement, JsonPath typePath, ConfigContext context) {
        return RewardRegistry.getFactory(type).map(factory -> factory.create(new RewardConfigContextImpl(context, maybeDataElement)).mapSuccess(instance -> new SkillRewardConfig(type, (Reward)instance))).orElseGet(() -> Result.failure(typePath.createProblem("Expected a valid reward type")));
    }

    public void dispose(DisposeContext context) {
        this.instance.dispose(new RewardDisposeContextImpl(context));
    }

    public ResourceLocation getType() {
        return this.type;
    }

    public Reward getInstance() {
        return this.instance;
    }
}

