/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.puffish.skillsmod.access.DamageSourceAccess;
import net.puffish.skillsmod.access.WorldChunkAccess;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.experience.source.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.TakeDamageExperienceSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private int entityDroppedXp = 0;

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void injectAtDamage(DamageSource source, float damage, CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            SkillsAPI.updateExperienceSources(serverPlayer, TakeDamageExperienceSource.class, experienceSource -> experienceSource.getValue(serverPlayer, damage, source));
        }
    }

    @Inject(method={"drop"}, at={@At(value="TAIL")})
    private void injectAtDrop(DamageSource source, CallbackInfo ci) {
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            LivingEntity entity2 = (LivingEntity)this;
            ItemStack weapon = ((DamageSourceAccess)source).getWeapon().orElse(ItemStack.f_41583_);
            WorldChunkAccess worldChunk = (WorldChunkAccess)entity2.m_9236_().m_46745_(entity2.m_20183_());
            worldChunk.antiFarmingCleanupOutdated();
            SkillsAPI.updateExperienceSources(player, experienceSource -> {
                if (experienceSource instanceof KillEntityExperienceSource) {
                    KillEntityExperienceSource entityExperienceSource = (KillEntityExperienceSource)experienceSource;
                    if (entityExperienceSource.getAntiFarming().map(worldChunk::antiFarmingAddAndCheck).orElse(true).booleanValue()) {
                        return entityExperienceSource.getValue(player, entity2, weapon, source, this.entityDroppedXp);
                    }
                }
                return 0;
            });
        }
    }

    @ModifyArg(method={"dropXp"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ExperienceOrbEntity;spawn(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/util/math/Vec3d;I)V"), index=2)
    private int injectAtDropXp(int droppedXp) {
        this.entityDroppedXp = droppedXp;
        return droppedXp;
    }
}

