/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.reward.builtin;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.reward.Reward;
import net.puffish.skillsmod.api.reward.RewardConfigContext;
import net.puffish.skillsmod.api.reward.RewardDisposeContext;
import net.puffish.skillsmod.api.reward.RewardUpdateContext;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public class ScoreboardReward
implements Reward {
    public static final ResourceLocation ID = SkillsMod.createIdentifier("scoreboard");
    private final String objectiveName;

    private ScoreboardReward(String objectiveName) {
        this.objectiveName = objectiveName;
    }

    public static void register() {
        SkillsAPI.registerReward(ID, ScoreboardReward::parse);
    }

    private static Result<ScoreboardReward, Problem> parse(RewardConfigContext context) {
        return context.getData().andThen(JsonElement::getAsObject).andThen(ScoreboardReward::parse);
    }

    private static Result<ScoreboardReward, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<String> optObjective = rootObject.getString("scoreboard").orElse(problem -> rootObject.getString("objective")).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new ScoreboardReward(optObjective.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }

    @Override
    public void update(RewardUpdateContext context) {
        ServerPlayer player = context.getPlayer();
        Scoreboard scoreboard = player.m_36329_();
        Objective objective = scoreboard.m_83469_(this.objectiveName);
        if (objective != null) {
            scoreboard.m_83471_(player.m_6302_(), objective).m_83402_(context.getCount());
        }
    }

    @Override
    public void dispose(RewardDisposeContext context) {
    }
}

