/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.calculation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.puffish.skillsmod.api.calculation.Calculation;
import net.puffish.skillsmod.api.calculation.Variables;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.JsonArray;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.CalculationCase;

public class CalculationImpl<T>
implements Calculation<T> {
    private final Variables<T, Double> variables;
    private final List<CalculationCase> cases;

    private CalculationImpl(Variables<T, Double> variables, List<CalculationCase> cases) {
        this.variables = variables;
        this.cases = cases;
    }

    @Override
    public double evaluate(T t) {
        return this.cases.stream().flatMap(calc -> calc.getValue(this.variables.evaluate(t)).stream()).findFirst().orElse(0.0);
    }

    public static <T> Result<CalculationImpl<T>, Problem> create(JsonElement rootElement, Variables<T, Double> variables, ConfigContext context) {
        Set variableNames = variables.streamNames().collect(Collectors.toSet());
        return rootElement.getAsArray().andThen(rootObject -> CalculationImpl.create(rootObject, variables, variableNames, context)).orElse(failure -> CalculationCase.parseSimplified(rootElement, variableNames).mapSuccess(calculationCase -> new CalculationImpl(variables, List.of(calculationCase))));
    }

    private static <T> Result<CalculationImpl<T>, Problem> create(JsonArray rootArray, Variables<T, Double> variables, Set<String> variableNames, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optCalculations = rootArray.getAsList((i, element) -> CalculationCase.parse(element, variableNames)).mapFailure(Problem::combine).ifFailure(problems::add).getSuccess();
        if (problems.isEmpty()) {
            return Result.success(new CalculationImpl<T>(variables, optCalculations.orElseThrow()));
        }
        return Result.failure(Problem.combine(problems));
    }
}

