/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.api.json;

import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public final class BuiltinJson {
    private BuiltinJson() {
    }

    public static Result<ResourceLocation, Problem> parseIdentifier(JsonElement element) {
        try {
            return Result.success(new ResourceLocation(element.getJson().getAsString()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid identifier"));
        }
    }

    public static Result<String, Problem> parseIdentifierPath(JsonElement element) {
        try {
            return Result.success(new ResourceLocation("minecraft", element.getJson().getAsString()).m_135815_());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid identifier path"));
        }
    }

    public static Result<MobEffect, Problem> parseEffect(JsonElement element) {
        return BuiltinJson.parseSomething(BuiltInRegistries.f_256974_, element, () -> "Expected valid effect");
    }

    public static Result<HolderSet<MobEffect>, Problem> parseEffectTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(BuiltInRegistries.f_256974_, element, () -> "Expected valid effect tag");
    }

    public static Result<HolderSet<MobEffect>, Problem> parseEffectOrEffectTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(BuiltInRegistries.f_256974_, element, () -> "Expected valid effect or effect tag");
    }

    public static Result<Block, Problem> parseBlock(JsonElement element) {
        return BuiltinJson.parseSomething(BuiltInRegistries.f_256975_, element, () -> "Expected valid block");
    }

    public static Result<HolderSet<Block>, Problem> parseBlockTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(BuiltInRegistries.f_256975_, element, () -> "Expected valid block tag");
    }

    public static Result<HolderSet<Block>, Problem> parseBlockOrBlockTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(BuiltInRegistries.f_256975_, element, () -> "Expected valid block or block tag");
    }

    public static Result<DamageType, Problem> parseDamageType(JsonElement element, RegistryAccess manager) {
        return BuiltinJson.parseSomething(manager.m_175515_(Registries.f_268580_), element, () -> "Expected valid damage type");
    }

    public static Result<HolderSet<DamageType>, Problem> parseDamageTypeTag(JsonElement element, RegistryAccess manager) {
        return BuiltinJson.parseSomethingTag(manager.m_175515_(Registries.f_268580_), element, () -> "Expected valid damage type tag");
    }

    public static Result<HolderSet<DamageType>, Problem> parseDamageTypeOrDamageTypeTag(JsonElement element, RegistryAccess manager) {
        return BuiltinJson.parseSomethingOrSomethingTag(manager.m_175515_(Registries.f_268580_), element, () -> "Expected valid damage type or damage type tag");
    }

    public static Result<EntityType<?>, Problem> parseEntityType(JsonElement element) {
        return BuiltinJson.parseSomething(BuiltInRegistries.f_256780_, element, () -> "Expected valid entity type");
    }

    public static Result<HolderSet<EntityType<?>>, Problem> parseEntityTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(BuiltInRegistries.f_256780_, element, () -> "Expected valid entity type tag");
    }

    public static Result<HolderSet<EntityType<?>>, Problem> parseEntityTypeOrEntityTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(BuiltInRegistries.f_256780_, element, () -> "Expected valid entity type or entity type tag");
    }

    public static Result<Item, Problem> parseItem(JsonElement element) {
        return BuiltinJson.parseSomething(BuiltInRegistries.f_257033_, element, () -> "Expected valid item");
    }

    public static Result<HolderSet<Item>, Problem> parseItemTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(BuiltInRegistries.f_257033_, element, () -> "Expected valid item tag");
    }

    public static Result<HolderSet<Item>, Problem> parseItemOrItemTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(BuiltInRegistries.f_257033_, element, () -> "Expected valid item or item tag");
    }

    public static Result<StatType<?>, Problem> parseStatType(JsonElement element) {
        return BuiltinJson.parseSomething(BuiltInRegistries.f_256899_, element, () -> "Expected valid stat type");
    }

    public static Result<HolderSet<StatType<?>>, Problem> parseStatTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingTag(BuiltInRegistries.f_256899_, element, () -> "Expected valid stat type tag");
    }

    public static Result<HolderSet<StatType<?>>, Problem> parseStatTypeOrStatTypeTag(JsonElement element) {
        return BuiltinJson.parseSomethingOrSomethingTag(BuiltInRegistries.f_256899_, element, () -> "Expected valid stat type or stat type tag");
    }

    public static Result<StatePropertiesPredicate, Problem> parseStatePredicate(JsonElement element) {
        try {
            return Result.success((StatePropertiesPredicate)StatePropertiesPredicate.m_67679_((com.google.gson.JsonElement)element.getJson()).orElseThrow());
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid state predicate"));
        }
    }

    public static Result<NbtPredicate, Problem> parseNbtPredicate(JsonElement element) {
        try {
            return Result.success(new NbtPredicate(TagParser.m_129359_((String)element.getJson().getAsString())));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid state predicate"));
        }
    }

    public static Result<Stat<?>, Problem> parseStat(JsonElement element) {
        try {
            return BuiltinJson.parseIdentifier(element).mapSuccess(id -> BuiltinJson.getOrCreateStat((StatType)BuiltInRegistries.f_256899_.m_6612_(ResourceLocation.m_135822_((String)id.m_135827_(), (char)'.')).orElseThrow(), ResourceLocation.m_135822_((String)id.m_135815_(), (char)'.')));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid stat"));
        }
    }

    private static <T> Stat<T> getOrCreateStat(StatType<T> statType, ResourceLocation id) {
        return statType.m_12902_(statType.m_12893_().m_6612_(id).orElseThrow());
    }

    public static Result<CompoundTag, Problem> parseNbt(JsonElement element) {
        try {
            return Result.success(TagParser.m_129359_((String)element.getJson().getAsString()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid nbt"));
        }
    }

    public static Result<ItemStack, Problem> parseItemStack(JsonElement element) {
        try {
            return element.getAsObject().andThen(object -> {
                ArrayList<Problem> problems = new ArrayList<Problem>();
                Optional item = object.get("item").andThen(BuiltinJson::parseItem).ifFailure(problems::add).getSuccess();
                Optional nbt = object.get("nbt").getSuccess().flatMap(nbtElement -> BuiltinJson.parseNbt(nbtElement).ifFailure(problems::add).getSuccess());
                if (problems.isEmpty()) {
                    ItemStack itemStack = new ItemStack((ItemLike)item.orElseThrow());
                    nbt.ifPresent(arg_0 -> ((ItemStack)itemStack).m_41751_(arg_0));
                    return Result.success(itemStack);
                }
                return Result.failure(Problem.combine(problems));
            });
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid item stack"));
        }
    }

    public static Result<FrameType, Problem> parseFrame(JsonElement element) {
        try {
            return element.getAsString().andThen(name -> Result.success(FrameType.m_15549_((String)name)));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid frame"));
        }
    }

    public static Result<Component, Problem> parseText(JsonElement element) {
        try {
            return Result.success(Component.Serializer.m_130691_((com.google.gson.JsonElement)element.getJson()));
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid text"));
        }
    }

    public static Result<Attribute, Problem> parseAttribute(JsonElement element) {
        try {
            return BuiltinJson.parseIdentifier(element).mapSuccess(id -> {
                if (id.m_135827_().equals("puffish_skills")) {
                    id = new ResourceLocation("puffish_attributes", id.m_135815_());
                }
                return (Attribute)BuiltInRegistries.f_256951_.m_6612_(id).orElseThrow();
            });
        }
        catch (Exception e) {
            return Result.failure(element.getPath().createProblem("Expected valid attribute"));
        }
    }

    public static Result<AttributeModifier.Operation, Problem> parseAttributeOperation(JsonElement element) {
        return element.getAsString().andThen(string -> switch (string) {
            case "addition" -> Result.success(AttributeModifier.Operation.ADDITION);
            case "multiply_base" -> Result.success(AttributeModifier.Operation.MULTIPLY_BASE);
            case "multiply_total" -> Result.success(AttributeModifier.Operation.MULTIPLY_TOTAL);
            default -> Result.failure(element.getPath().createProblem("Expected valid attribute operation"));
        });
    }

    private static <T> Result<T, Problem> parseSomething(Registry<T> registry, JsonElement element, Supplier<String> message) {
        try {
            String string = element.getJson().getAsString();
            return Result.success(registry.m_6612_(new ResourceLocation(string)).orElseThrow());
        }
        catch (Exception ignored) {
            return Result.failure(element.getPath().createProblem(message.get()));
        }
    }

    private static <T> Result<HolderSet<T>, Problem> parseSomethingTag(Registry<T> registry, JsonElement element, Supplier<String> message) {
        try {
            String string = element.getJson().getAsString();
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            return Result.success((HolderSet)registry.m_255303_().m_254901_(TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)new ResourceLocation(string))).orElseThrow());
        }
        catch (Exception ignored) {
            return Result.failure(element.getPath().createProblem(message.get()));
        }
    }

    private static <T> Result<HolderSet<T>, Problem> parseSomethingOrSomethingTag(Registry<T> registry, JsonElement element, Supplier<String> message) {
        try {
            String string = element.getJson().getAsString();
            if (string.startsWith("#")) {
                return Result.success((HolderSet)registry.m_255303_().m_254901_(TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)new ResourceLocation(string.substring(1)))).orElseThrow());
            }
            return Result.success(HolderSet.m_205809_((Holder[])new Holder[]{(Holder)registry.m_203636_(ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)new ResourceLocation(string))).orElseThrow()}));
        }
        catch (Exception ignored) {
            return Result.failure(element.getPath().createProblem(message.get()));
        }
    }
}

