/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public record ClientBackgroundConfig(ResourceLocation texture, int width, int height, Position position) {
    public static ClientBackgroundConfig createMissing() {
        return new ClientBackgroundConfig(TextureManager.f_118466_, 16, 16, Position.TILE);
    }

    public static Result<ClientBackgroundConfig, Problem> parse(JsonElement rootElement) {
        return rootElement.getAsObject().andThen(ClientBackgroundConfig::parse);
    }

    public static Result<ClientBackgroundConfig, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optTexture = rootObject.get("texture").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
        Optional<Integer> optWidth = rootObject.getInt("width").ifFailure(problems::add).getSuccess();
        Optional<Integer> optHeight = rootObject.getInt("height").ifFailure(problems::add).getSuccess();
        Position position = rootObject.get("position").getSuccess().flatMap(element -> Position.parse(element).ifFailure(problems::add).getSuccess()).orElse(Position.NONE);
        if (problems.isEmpty()) {
            return Result.success(new ClientBackgroundConfig((ResourceLocation)optTexture.orElseThrow(), optWidth.orElseThrow(), optHeight.orElseThrow(), position));
        }
        return Result.failure(Problem.combine(problems));
    }

    public static enum Position {
        NONE,
        TILE,
        FILL,
        FILL_WIDTH,
        FILL_HEIGHT;


        public static Result<Position, Problem> parse(JsonElement rootElement) {
            return rootElement.getAsString().andThen(string -> switch (string) {
                case "none" -> Result.success(NONE);
                case "tile" -> Result.success(TILE);
                case "fill" -> Result.success(FILL);
                case "fill_width" -> Result.success(FILL_WIDTH);
                case "fill_height" -> Result.success(FILL_HEIGHT);
                default -> Result.failure(rootElement.getPath().createProblem("Expected valid background position"));
            });
        }
    }
}

