/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.config;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.advancements.FrameType;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClientFrameConfig {

    public record TextureFrameConfig(Optional<ResourceLocation> lockedTexture, ResourceLocation availableTexture, Optional<ResourceLocation> affordableTexture, ResourceLocation unlockedTexture, Optional<ResourceLocation> excludedTexture) implements ClientFrameConfig
    {
        public static Result<TextureFrameConfig, Problem> parse(JsonElement rootElement) {
            return rootElement.getAsObject().andThen(TextureFrameConfig::parse);
        }

        private static Result<TextureFrameConfig, Problem> parse(JsonObject rootObject) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            Optional<ResourceLocation> optAffordableTexture = rootObject.get("affordable").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            Optional optAvailableTexture = rootObject.get("available").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
            Optional<ResourceLocation> optLockedTexture = rootObject.get("locked").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            Optional optUnlockedTexture = rootObject.get("unlocked").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
            Optional<ResourceLocation> optExcludedTexture = rootObject.get("excluded").getSuccess().flatMap(element -> BuiltinJson.parseIdentifier(element).ifFailure(problems::add).getSuccess());
            if (problems.isEmpty()) {
                return Result.success(new TextureFrameConfig(optLockedTexture, (ResourceLocation)optAvailableTexture.orElseThrow(), optAffordableTexture, (ResourceLocation)optUnlockedTexture.orElseThrow(), optExcludedTexture));
            }
            return Result.failure(Problem.combine(problems));
        }

        public static TextureFrameConfig createMissing() {
            return new TextureFrameConfig(Optional.of(TextureManager.f_118466_), TextureManager.f_118466_, Optional.of(TextureManager.f_118466_), TextureManager.f_118466_, Optional.of(TextureManager.f_118466_));
        }
    }

    public record AdvancementFrameConfig(FrameType frame) implements ClientFrameConfig
    {
        public static Result<AdvancementFrameConfig, Problem> parse(JsonElement rootElement) {
            return rootElement.getAsObject().andThen(rootObject -> rootObject.get("frame")).andThen(BuiltinJson::parseFrame).mapSuccess(AdvancementFrameConfig::new);
        }
    }
}

