/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.metadata.gui.GuiSpriteScaling;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4fc;

public class TextureBatchedRenderer {
    private final Map<ResourceLocation, List<TextureEmit>> batch = new HashMap<ResourceLocation, List<TextureEmit>>();

    public void emitTexture(GuiGraphics context, ResourceLocation texture, int x, int y, int width, int height, Vector4fc color) {
        this.emitTextureBatched(context, texture, x, y, x + width, y + height, 0.0f, 0.0f, 1.0f, 1.0f, color);
    }

    public void emitSprite(GuiGraphics context, TextureAtlasSprite sprite, GuiSpriteScaling scaling, int x, int y, int width, int height, Vector4fc color) {
        if (scaling instanceof GuiSpriteScaling.Stretch) {
            this.emitSpriteStretch(context, sprite, x, y, width, height, color);
        } else if (scaling instanceof GuiSpriteScaling.Tile) {
            GuiSpriteScaling.Tile tile = (GuiSpriteScaling.Tile)scaling;
            this.emitSpriteTile(context, sprite, tile, x, y, width, height, color);
        } else if (scaling instanceof GuiSpriteScaling.NineSlice) {
            GuiSpriteScaling.NineSlice nineSlice = (GuiSpriteScaling.NineSlice)scaling;
            this.emitSpriteNineSlice(context, sprite, nineSlice, x, y, width, height, color);
        }
    }

    private void emitSpriteTile(GuiGraphics context, TextureAtlasSprite sprite, GuiSpriteScaling.Tile tile, int x, int y, int width, int height, Vector4fc color) {
        if (width <= 0 || height <= 0 || tile.f_290745_() <= 0 || tile.f_290706_() <= 0) {
            return;
        }
        for (int tileX = 0; tileX < width; tileX += tile.f_290745_()) {
            int tileWidth = Math.min(tile.f_290745_(), width - tileX);
            for (int tileY = 0; tileY < height; tileY += tile.f_290706_()) {
                int tileHeight = Math.min(tile.f_290706_(), height - tileY);
                this.emitSpriteStretch(context, sprite, x + tileX, y + tileY, tileWidth, tileHeight, color);
            }
        }
    }

    private void emitSpriteNineSlice(GuiGraphics context, TextureAtlasSprite sprite, GuiSpriteScaling.NineSlice nineSlice, int x, int y, int width, int height, Vector4fc color) {
        int tileWidth;
        int tileX;
        if (width == nineSlice.f_291615_() && height == nineSlice.f_291235_()) {
            this.emitSpriteStretch(context, sprite, x, y, width, height, color);
            return;
        }
        GuiSpriteScaling.NineSlice.Border border = nineSlice.f_291546_();
        int left = Math.min(border.f_291443_(), width / 2);
        int top = Math.min(border.f_291022_(), height / 2);
        int right = Math.min(border.f_290714_(), width / 2);
        int bottom = Math.min(border.f_290453_(), height / 2);
        if (width == nineSlice.f_291615_()) {
            this.emitTextureBatched(context, sprite.m_247685_(), x, y, x + width, y + top, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118393_((float)top / (float)nineSlice.f_291235_()), color);
            for (int tileY = top; tileY < height - bottom; tileY += nineSlice.f_291235_() - top - bottom) {
                int tileHeight = Math.min(nineSlice.f_291235_() - top - bottom, height - bottom - tileY);
                this.emitTextureBatched(context, sprite.m_247685_(), x, y + tileY, x + nineSlice.f_291615_(), y + tileY + tileHeight, sprite.m_118409_(), sprite.m_118393_((float)top / (float)nineSlice.f_291235_()), sprite.m_118410_(), sprite.m_118393_((float)(top + tileHeight) / (float)nineSlice.f_291235_()), color);
            }
            this.emitTextureBatched(context, sprite.m_247685_(), x, y + height - bottom, x + width, y + height, sprite.m_118409_(), sprite.m_118393_((float)(nineSlice.f_291235_() - bottom) / (float)nineSlice.f_291235_()), sprite.m_118410_(), sprite.m_118412_(), color);
            return;
        }
        if (height == nineSlice.f_291235_()) {
            this.emitTextureBatched(context, sprite.m_247685_(), x, y, x + left, y + height, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118367_((float)left / (float)nineSlice.f_291615_()), sprite.m_118412_(), color);
            for (int tileX2 = left; tileX2 < width - right; tileX2 += nineSlice.f_291615_() - left - right) {
                int tileWidth2 = Math.min(nineSlice.f_291615_() - left - right, width - right - tileX2);
                this.emitTextureBatched(context, sprite.m_247685_(), x + tileX2, y, x + tileX2 + tileWidth2, y + nineSlice.f_291235_(), sprite.m_118367_((float)left / (float)nineSlice.f_291615_()), sprite.m_118411_(), sprite.m_118367_((float)(left + tileWidth2) / (float)nineSlice.f_291615_()), sprite.m_118412_(), color);
            }
            this.emitTextureBatched(context, sprite.m_247685_(), x + width - right, y, x + width, y + height, sprite.m_118367_((float)(nineSlice.f_291615_() - right) / (float)nineSlice.f_291615_()), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), color);
            return;
        }
        this.emitTextureBatched(context, sprite.m_247685_(), x, y, x + left, y + right, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118367_((float)left / (float)nineSlice.f_291615_()), sprite.m_118393_((float)right / (float)nineSlice.f_291615_()), color);
        this.emitTextureBatched(context, sprite.m_247685_(), x + width - right, y, x + width, y + top, sprite.m_118367_((float)(nineSlice.f_291615_() - right) / (float)nineSlice.f_291615_()), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118393_((float)top / (float)nineSlice.f_291235_()), color);
        this.emitTextureBatched(context, sprite.m_247685_(), x + width - right, y + height - bottom, x + width, y + height, sprite.m_118367_((float)(nineSlice.f_291615_() - right) / (float)nineSlice.f_291615_()), sprite.m_118393_((float)(nineSlice.f_291235_() - bottom) / (float)nineSlice.f_291235_()), sprite.m_118410_(), sprite.m_118412_(), color);
        this.emitTextureBatched(context, sprite.m_247685_(), x, y + height - bottom, x + left, y + height, sprite.m_118409_(), sprite.m_118393_((float)(nineSlice.f_291235_() - bottom) / (float)nineSlice.f_291235_()), sprite.m_118367_((float)left / (float)nineSlice.f_291615_()), sprite.m_118412_(), color);
        for (tileX = left; tileX < width - right; tileX += nineSlice.f_291615_() - left - right) {
            tileWidth = Math.min(nineSlice.f_291615_() - left - right, width - right - tileX);
            this.emitTextureBatched(context, sprite.m_247685_(), x + tileX, y, x + tileX + tileWidth, y + top, sprite.m_118367_((float)left / (float)nineSlice.f_291615_()), sprite.m_118411_(), sprite.m_118367_((float)(left + tileWidth) / (float)nineSlice.f_291615_()), sprite.m_118393_((float)top / (float)nineSlice.f_291235_()), color);
            this.emitTextureBatched(context, sprite.m_247685_(), x + tileX, y + height - bottom, x + tileX + tileWidth, y + height, sprite.m_118367_((float)left / (float)nineSlice.f_291615_()), sprite.m_118393_((float)(nineSlice.f_291235_() - bottom) / (float)nineSlice.f_291235_()), sprite.m_118367_((float)(left + tileWidth) / (float)nineSlice.f_291615_()), sprite.m_118412_(), color);
        }
        for (int tileY = top; tileY < height - bottom; tileY += nineSlice.f_291235_() - top - bottom) {
            int tileHeight = Math.min(nineSlice.f_291235_() - top - bottom, height - bottom - tileY);
            this.emitTextureBatched(context, sprite.m_247685_(), x, y + tileY, x + left, y + tileY + tileHeight, sprite.m_118409_(), sprite.m_118393_((float)top / (float)nineSlice.f_291235_()), sprite.m_118367_((float)left / (float)nineSlice.f_291615_()), sprite.m_118393_((float)(top + tileHeight) / (float)nineSlice.f_291235_()), color);
            this.emitTextureBatched(context, sprite.m_247685_(), x + width - right, y + tileY, x + width, y + tileY + tileHeight, sprite.m_118367_((float)(nineSlice.f_291615_() - right) / (float)nineSlice.f_291615_()), sprite.m_118393_((float)top / (float)nineSlice.f_291235_()), sprite.m_118410_(), sprite.m_118393_((float)(top + tileHeight) / (float)nineSlice.f_291235_()), color);
        }
        for (tileX = left; tileX < width - right; tileX += nineSlice.f_291615_() - left - right) {
            tileWidth = Math.min(nineSlice.f_291615_() - left - right, width - right - tileX);
            for (int tileY = top; tileY < height - bottom; tileY += nineSlice.f_291235_() - top - bottom) {
                int tileHeight = Math.min(nineSlice.f_291235_() - top - bottom, height - bottom - tileY);
                this.emitTextureBatched(context, sprite.m_247685_(), x + tileX, y + tileY, x + tileX + tileWidth, y + tileY + tileHeight, sprite.m_118367_((float)left / (float)nineSlice.f_291615_()), sprite.m_118393_((float)top / (float)nineSlice.f_291235_()), sprite.m_118367_((float)(left + tileWidth) / (float)nineSlice.f_291615_()), sprite.m_118393_((float)(top + tileHeight) / (float)nineSlice.f_291235_()), color);
            }
        }
    }

    private void emitSpriteStretch(GuiGraphics context, TextureAtlasSprite sprite, int x, int y, int width, int height, Vector4fc color) {
        this.emitTextureBatched(context, sprite.m_247685_(), x, y, x + width, y + height, sprite.m_118409_(), sprite.m_118411_(), sprite.m_118410_(), sprite.m_118412_(), color);
    }

    private void emitTextureBatched(GuiGraphics context, ResourceLocation texture, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, Vector4fc color) {
        List emits = this.batch.computeIfAbsent(texture, key -> new ArrayList());
        Matrix4f matrix = context.m_280168_().m_85850_().m_252922_();
        Vector3f v1 = matrix.transformPosition(new Vector3f(minX, minY, 0.0f));
        Vector3f v2 = matrix.transformPosition(new Vector3f(minX, maxY, 0.0f));
        Vector3f v3 = matrix.transformPosition(new Vector3f(maxX, maxY, 0.0f));
        Vector3f v4 = matrix.transformPosition(new Vector3f(maxX, minY, 0.0f));
        emits.add(new TextureEmit(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, v3.x, v3.y, v3.z, v4.x, v4.y, v4.z, minU, minV, maxU, maxV, color));
    }

    public void draw() {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172814_);
        for (Map.Entry<ResourceLocation, List<TextureEmit>> entry : this.batch.entrySet()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)entry.getKey());
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
            for (TextureEmit emit : entry.getValue()) {
                bufferBuilder.m_5483_((double)emit.x1, (double)emit.y1, (double)emit.z1).m_85950_(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).m_7421_(emit.minU, emit.minV).m_5752_();
                bufferBuilder.m_5483_((double)emit.x2, (double)emit.y2, (double)emit.z2).m_85950_(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).m_7421_(emit.minU, emit.maxV).m_5752_();
                bufferBuilder.m_5483_((double)emit.x3, (double)emit.y3, (double)emit.z3).m_85950_(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).m_7421_(emit.maxU, emit.maxV).m_5752_();
                bufferBuilder.m_5483_((double)emit.x4, (double)emit.y4, (double)emit.z4).m_85950_(emit.color.x(), emit.color.y(), emit.color.z(), emit.color.w()).m_7421_(emit.maxU, emit.minV).m_5752_();
            }
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
        this.batch.clear();
    }

    private record TextureEmit(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float minU, float minV, float maxU, float maxV, Vector4fc color) {
    }
}

