/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.config;

import java.util.ArrayList;
import java.util.List;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;

public class ModConfig {
    private final boolean showWarnings;
    private final List<String> categories;

    private ModConfig(boolean showWarnings, List<String> categories) {
        this.showWarnings = showWarnings;
        this.categories = categories;
    }

    public static Result<ModConfig, Problem> parse(JsonElement rootElement) {
        return rootElement.getAsObject().andThen(ModConfig::parse);
    }

    public static Result<ModConfig, Problem> parse(JsonObject rootObject) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Integer version = rootObject.getInt("version").getSuccessOrElse(e -> Integer.MIN_VALUE);
        Boolean showWarnings = rootObject.getBoolean("show_warnings").getSuccessOrElse(e -> false);
        if (version < 1) {
            return Result.failure(Problem.message("Configuration is outdated. Check out the mod's wiki to learn how to update the configuration."));
        }
        if (version > 2) {
            return Result.failure(Problem.message("Configuration is for a newer version of the mod. Please update the mod."));
        }
        List categories = rootObject.get("categories").getSuccess().flatMap(categoriesElement -> categoriesElement.getAsArray().andThen(array -> array.getAsList((i, element) -> BuiltinJson.parseIdentifierPath(element)).mapFailure(Problem::combine)).ifFailure(problems::add).getSuccess()).orElseGet(List::of);
        if (problems.isEmpty()) {
            return Result.success(new ModConfig(showWarnings, categories));
        }
        return Result.failure(Problem.combine(problems));
    }

    public boolean getShowWarnings() {
        return this.showWarnings;
    }

    public List<String> getCategories() {
        return this.categories;
    }
}

