/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.EventNetworkChannel;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.event.ClientEventListener;
import net.puffish.skillsmod.client.event.ClientEventReceiver;
import net.puffish.skillsmod.client.keybinding.KeyBindingHandler;
import net.puffish.skillsmod.client.keybinding.KeyBindingReceiver;
import net.puffish.skillsmod.client.network.ClientPacketHandler;
import net.puffish.skillsmod.client.network.ClientPacketSender;
import net.puffish.skillsmod.client.setup.ClientRegistrar;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import org.apache.commons.lang3.ArrayUtils;

public class ForgeClientMain {
    private final List<ClientEventListener> clientListeners = new ArrayList<ClientEventListener>();
    private final List<KeyBindingWithHandler> keyBindings = new ArrayList<KeyBindingWithHandler>();

    public ForgeClientMain() {
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        forgeEventBus.addListener(this::onPlayerLoggedIn);
        forgeEventBus.addListener(this::onInputKey);
        SkillsClientMod.setup(new ClientRegistrarImpl(), new ClientEventReceiverImpl(), new KeyBindingReceiverImpl(), new ClientPacketSenderImpl());
    }

    private void onPlayerLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        for (ClientEventListener listener : this.clientListeners) {
            listener.onPlayerJoin();
        }
    }

    private void onInputKey(InputEvent.Key event) {
        for (KeyBindingWithHandler keyBinding : this.keyBindings) {
            if (!keyBinding.keyBinding.m_90859_()) continue;
            keyBinding.handler.handle();
        }
    }

    private static class ClientRegistrarImpl
    implements ClientRegistrar {
        private ClientRegistrarImpl() {
        }

        @Override
        public <T extends InPacket> void registerInPacket(ResourceLocation identifier, Function<FriendlyByteBuf, T> reader, ClientPacketHandler<T> handler) {
            EventNetworkChannel channel = ChannelBuilder.named((ResourceLocation)identifier).serverAcceptedVersions((status, version) -> true).clientAcceptedVersions((status, version) -> true).eventNetworkChannel();
            channel.addListener(networkEvent -> {
                CustomPayloadEvent.Context context = networkEvent.getSource();
                if (context.getPacketHandled()) {
                    return;
                }
                if (context.isClientSide()) {
                    InPacket packet = (InPacket)reader.apply(networkEvent.getPayload());
                    context.enqueueWork(() -> handler.handle(packet));
                    context.setPacketHandled(true);
                }
            });
        }

        @Override
        public void registerOutPacket(ResourceLocation id) {
        }
    }

    private class ClientEventReceiverImpl
    implements ClientEventReceiver {
        private ClientEventReceiverImpl() {
        }

        @Override
        public void registerListener(ClientEventListener eventListener) {
            ForgeClientMain.this.clientListeners.add(eventListener);
        }
    }

    private class KeyBindingReceiverImpl
    implements KeyBindingReceiver {
        private KeyBindingReceiverImpl() {
        }

        @Override
        public void registerKeyBinding(KeyMapping keyBinding, KeyBindingHandler handler) {
            ForgeClientMain.this.keyBindings.add(new KeyBindingWithHandler(keyBinding, handler));
            Options options = Minecraft.m_91087_().f_91066_;
            options.f_92059_ = (KeyMapping[])ArrayUtils.add((Object[])options.f_92059_, (Object)keyBinding);
        }
    }

    private static class ClientPacketSenderImpl
    implements ClientPacketSender {
        private ClientPacketSenderImpl() {
        }

        @Override
        public void send(OutPacket packet) {
            Objects.requireNonNull(Minecraft.m_91087_().m_91403_()).m_295327_((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new DiscardedPayload(packet.getIdentifier(), packet.getBuf())));
        }
    }

    private record KeyBindingWithHandler(KeyMapping keyBinding, KeyBindingHandler handler) {
    }
}

