/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.puffish.skillsmod.server.data.PlayerData;

public class ServerData
extends SavedData {
    public final Map<UUID, PlayerData> players = new HashMap<UUID, PlayerData>();

    private ServerData() {
    }

    private static ServerData read(CompoundTag tag) {
        ServerData playersData = new ServerData();
        CompoundTag playersNbt = tag.m_128469_("players");
        playersNbt.m_128431_().forEach(key -> playersData.players.put(UUID.fromString(key), PlayerData.read(playersNbt.m_128469_(key))));
        return playersData;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        CompoundTag playersNbt = new CompoundTag();
        for (Map.Entry<UUID, PlayerData> entry : this.players.entrySet()) {
            playersNbt.m_128365_(entry.getKey().toString(), (Tag)entry.getValue().writeNbt(new CompoundTag()));
        }
        nbt.m_128365_("players", (Tag)playersNbt);
        return nbt;
    }

    public static SavedData.Factory<ServerData> getPersistentStateType() {
        return new SavedData.Factory(ServerData::new, ServerData::read, null);
    }

    public static ServerData getOrCreate(MinecraftServer server) {
        DimensionDataStorage persistentStateManager = server.m_129783_().m_8895_();
        return (ServerData)persistentStateManager.m_164861_(ServerData.getPersistentStateType(), "puffish_skills");
    }

    public PlayerData getPlayerData(ServerPlayer player) {
        return this.players.computeIfAbsent(player.m_20148_(), uuid -> PlayerData.empty());
    }

    public boolean m_77764_() {
        return true;
    }
}

