/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.server.network.packets.out;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.config.BackgroundConfig;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.FrameConfig;
import net.puffish.skillsmod.config.GeneralConfig;
import net.puffish.skillsmod.config.IconConfig;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillConnectionsConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionsConfig;
import net.puffish.skillsmod.config.skill.SkillsConfig;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.server.data.CategoryData;
import net.puffish.skillsmod.skill.SkillConnection;

public class ShowCategoryOutPacket
extends OutPacket {
    public static ShowCategoryOutPacket write(CategoryConfig category, CategoryData categoryData) {
        ShowCategoryOutPacket packet = new ShowCategoryOutPacket();
        ShowCategoryOutPacket.write(packet.buf, category, categoryData);
        return packet;
    }

    public static void write(FriendlyByteBuf buf, CategoryConfig category, CategoryData categoryData) {
        buf.m_130085_(category.getId());
        ShowCategoryOutPacket.write(buf, category.getGeneral());
        ShowCategoryOutPacket.write(buf, category.getDefinitions());
        ShowCategoryOutPacket.write(buf, category.getSkills());
        ShowCategoryOutPacket.write(buf, category.getConnections());
        buf.m_236831_(category.getSkills().getMap(), FriendlyByteBuf::m_130070_, (buf1, skill) -> buf1.m_130068_((Enum)categoryData.getSkillState(category, (SkillConfig)skill, category.getDefinitions().getById(skill.getDefinitionId()).orElseThrow())));
        buf.writeInt(categoryData.getSpentPoints(category));
        buf.writeInt(categoryData.getEarnedPoints(category));
        if (category.getExperience().isPresent()) {
            int level = categoryData.getCurrentLevel(category);
            buf.writeBoolean(true);
            buf.writeInt(level);
            buf.writeInt(categoryData.getCurrentExperience(category));
            buf.writeInt(categoryData.getRequiredExperience(category, level));
        } else {
            buf.writeBoolean(false);
        }
    }

    public static void write(FriendlyByteBuf buf, SkillDefinitionsConfig definitions) {
        buf.m_236828_(definitions.getAll(), ShowCategoryOutPacket::write);
    }

    public static void write(FriendlyByteBuf buf, GeneralConfig general) {
        buf.m_130083_(general.getTitle());
        ShowCategoryOutPacket.write(buf, general.getIcon());
        ShowCategoryOutPacket.write(buf, general.getBackground());
        buf.m_236821_((Object)general.getColors(), (buf1, element) -> buf1.m_130070_(element.toString()));
        buf.writeBoolean(general.isExclusiveRoot());
        buf.writeInt(general.getSpentPointsLimit());
    }

    public static void write(FriendlyByteBuf buf, SkillDefinitionConfig definition) {
        buf.m_130070_(definition.getId());
        buf.m_130083_(definition.getTitle());
        buf.m_130083_(definition.getDescription());
        buf.m_130083_(definition.getExtraDescription());
        ShowCategoryOutPacket.write(buf, definition.getFrame());
        ShowCategoryOutPacket.write(buf, definition.getIcon());
        buf.writeFloat(definition.getSize());
        buf.writeInt(definition.getCost());
        buf.writeInt(definition.getRequiredSkills());
        buf.writeInt(definition.getRequiredPoints());
        buf.writeInt(definition.getRequiredSpentPoints());
    }

    public static void write(FriendlyByteBuf buf, SkillsConfig skills) {
        buf.m_236828_(skills.getAll(), ShowCategoryOutPacket::write);
    }

    public static void write(FriendlyByteBuf buf, SkillConnectionsConfig connections) {
        buf.m_236828_(connections.getNormal().getAll(), ShowCategoryOutPacket::write);
        buf.m_236828_(connections.getExclusive().getAll(), ShowCategoryOutPacket::write);
    }

    public static void write(FriendlyByteBuf buf, SkillConfig skill) {
        buf.m_130070_(skill.getId());
        buf.writeInt(skill.getX());
        buf.writeInt(skill.getY());
        buf.m_130070_(skill.getDefinitionId());
        buf.writeBoolean(skill.isRoot());
    }

    public static void write(FriendlyByteBuf buf, SkillConnection skill) {
        buf.m_130070_(skill.skillAId());
        buf.m_130070_(skill.skillBId());
        buf.writeBoolean(skill.bidirectional());
    }

    public static void write(FriendlyByteBuf buf, IconConfig icon) {
        buf.m_130070_(icon.getType());
        buf.m_236821_((Object)icon.getData(), (buf1, element) -> buf1.m_130070_(element.toString()));
    }

    public static void write(FriendlyByteBuf buf, FrameConfig frame) {
        buf.m_130070_(frame.getType());
        buf.m_236821_((Object)frame.getData(), (buf1, element) -> buf1.m_130070_(element.toString()));
    }

    public static void write(FriendlyByteBuf buf, BackgroundConfig background) {
        buf.m_236821_((Object)background.getData(), (buf1, element) -> buf1.m_130070_(element.toString()));
    }

    @Override
    public ResourceLocation getIdentifier() {
        return Packets.SHOW_CATEGORY;
    }
}

