/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.alchemy;

import com.hyperlynx.reactive.alchemy.AlchemyTags;
import com.hyperlynx.reactive.alchemy.Powers;
import com.hyperlynx.reactive.util.Color;
import com.hyperlynx.reactive.util.PrimedWSV;
import com.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class Power
implements IForgeRegistryEntry<Power> {
    private final Color color;
    private final String id;
    private String name;
    private String domain;
    private final Item bottle;
    private final PrimedWSV percent_reactivity;

    public Power(String id, int color, Item bottle) {
        this.id = id;
        this.color = new Color(color);
        this.bottle = bottle;
        this.name = id.substring(0, 1).toUpperCase() + id.substring(1).toLowerCase();
        this.percent_reactivity = new PrimedWSV(id + "_reactivity", 33, 200);
        this.domain = "reactive";
    }

    public Power(String id, int color, String name, Item bottle) {
        this.id = id;
        this.color = new Color(color);
        this.bottle = bottle;
        this.name = name;
        this.percent_reactivity = new PrimedWSV(id + "_reactivity", 33, 200);
    }

    public Power(String id, Color color, String name, Item bottle) {
        this.id = id;
        this.color = color;
        this.bottle = bottle;
        this.name = name;
        this.percent_reactivity = new PrimedWSV(id + "_reactivity", 33, 200);
    }

    public static Power readPower(CompoundTag tag) {
        Power ret = null;
        for (RegistryObject reg : Powers.POWERS.getEntries()) {
            if (!((Power)reg.get()).getId().equals(tag.m_128461_("name"))) continue;
            ret = (Power)reg.get();
            break;
        }
        if (ret == null) {
            System.err.println("Failed to read power. This will break things.");
        }
        return ret;
    }

    public Color getColor() {
        return this.color;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean checkReactivity(int power_level, int threshold) {
        float strength = (float)this.percent_reactivity.get() / 100.0f;
        int adjusted_power_level = (int)((float)power_level * strength);
        return adjusted_power_level >= threshold;
    }

    public static List<Power> getSourcePower(ItemStack i) {
        ArrayList<Power> stack_powers = new ArrayList<Power>();
        if (i.m_204117_(AlchemyTags.acidSource)) {
            stack_powers.add((Power)Powers.ACID_POWER.get());
        }
        if (i.m_204117_(AlchemyTags.verdantSource)) {
            stack_powers.add((Power)Powers.VERDANT_POWER.get());
        }
        if (i.m_204117_(AlchemyTags.curseSource)) {
            stack_powers.add((Power)Powers.CURSE_POWER.get());
        }
        if (i.m_204117_(AlchemyTags.lightSource)) {
            stack_powers.add((Power)Powers.LIGHT_POWER.get());
        }
        if (i.m_204117_(AlchemyTags.mindSource)) {
            stack_powers.add((Power)Powers.MIND_POWER.get());
        }
        if (i.m_204117_(AlchemyTags.soulSource)) {
            stack_powers.add((Power)Powers.SOUL_POWER.get());
        }
        if (i.m_204117_(AlchemyTags.vitalSource)) {
            stack_powers.add((Power)Powers.VITAL_POWER.get());
        }
        if (i.m_204117_(AlchemyTags.warpSource)) {
            stack_powers.add((Power)Powers.WARP_POWER.get());
        }
        if (i.m_204117_(AlchemyTags.bodySource)) {
            stack_powers.add((Power)Powers.BODY_POWER.get());
        }
        return stack_powers;
    }

    public static int getSourceLevel(ItemStack i) {
        return WorldSpecificValue.get("power_" + i.m_41720_().m_5524_(), i.m_204117_(AlchemyTags.highPower) ? 250 : 25, i.m_204117_(AlchemyTags.highPower) ? 500 : 75);
    }

    public boolean hasBottle() {
        return this.bottle != null;
    }

    public boolean matchesBottle(ItemStack i) {
        if (this.hasBottle()) {
            return i.m_150930_(this.bottle);
        }
        return false;
    }

    public ItemStack getBottle() {
        if (this.hasBottle()) {
            return this.bottle.m_7968_();
        }
        return ItemStack.f_41583_;
    }

    public String toString() {
        return this.name;
    }

    public Power setRegistryName(ResourceLocation name) {
        this.domain = name.m_135827_();
        this.name = name.m_135815_();
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return new ResourceLocation(this.domain, this.name);
    }

    public Class<Power> getRegistryType() {
        return Power.class;
    }
}

