/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.alchemy;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.advancements.CriteriaTriggers;
import com.hyperlynx.reactive.advancements.FlagCriterion;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.Powers;
import com.hyperlynx.reactive.be.CrucibleBlockEntity;
import com.hyperlynx.reactive.blocks.IncompleteStaffBlock;
import com.hyperlynx.reactive.fx.ParticleScribe;
import com.hyperlynx.reactive.items.CrystalIronItem;
import com.hyperlynx.reactive.items.LitmusPaperItem;
import com.hyperlynx.reactive.items.PowerBottleItem;
import com.hyperlynx.reactive.items.WarpBottleItem;
import com.hyperlynx.reactive.util.ConfigMan;
import com.hyperlynx.reactive.util.HyperPortalShape;
import com.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ConfiguredStructureTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class SpecialCaseMan {
    public static void checkDissolveSpecialCases(CrucibleBlockEntity c, ItemEntity e) {
        if (e.m_32055_().m_150930_((Item)Registration.LITMUS_PAPER.get())) {
            LitmusPaperItem.takeMeasurement(e.m_32055_(), c);
        } else if (e.m_32055_().m_204117_(Tags.Items.ENDER_PEARLS)) {
            SpecialCaseMan.enderPearlDissolve(Objects.requireNonNull(c.m_58904_()), c.m_58899_(), e, c);
        } else if (e.m_32055_().m_204117_(Tags.Items.GUNPOWDER) && c.getPowerLevel((Power)Powers.BLAZE_POWER.get()) > 10) {
            SpecialCaseMan.explodeGunpowderDueToBlaze(Objects.requireNonNull(c.m_58904_()), c.m_58899_(), e);
        } else if (e.m_32055_().m_150930_(Items.f_42047_)) {
            SpecialCaseMan.pumpkinMagic(Objects.requireNonNull(c.m_58904_()), e, c);
        } else if (e.m_32055_().m_150930_(Items.f_42614_)) {
            SpecialCaseMan.waterWriting(c, e);
        } else if (e.m_32055_().m_204117_(Tags.Items.INGOTS_COPPER) && c.getPowerLevel((Power)Powers.ACID_POWER.get()) > 10) {
            SpecialCaseMan.copperCharging(c);
        } else if (e.m_32055_().m_150930_(Items.f_42545_) && c.getPowerLevel((Power)Powers.CURSE_POWER.get()) < 10) {
            SpecialCaseMan.enderEyeFlyAway(c, e);
        } else if (e.m_32055_().m_150930_((Item)Registration.PHANTOM_RESIDUE.get()) && c.getPowerLevel((Power)Powers.VERDANT_POWER.get()) > 700) {
            SpecialCaseMan.residualSlime(c, e);
        }
        PowerBottleItem.tryEmptyPowerBottle(e, c);
    }

    public static void checkEmptySpecialCases(CrucibleBlockEntity c) {
        if (c.m_58904_() == null) {
            return;
        }
        if (c.getPowerLevel((Power)Powers.SOUL_POWER.get()) > WorldSpecificValue.get("soul_escape_threshold", 300, 600)) {
            SpecialCaseMan.soulEscape(c);
        }
        if (c.getPowerLevel((Power)Powers.CURSE_POWER.get()) > 665) {
            SpecialCaseMan.curseEscape(c);
        }
        if (c.getPowerLevel((Power)Powers.BLAZE_POWER.get()) > WorldSpecificValue.get("blaze_escape_threshold", 20, 100)) {
            SpecialCaseMan.blazeEscape(c);
        }
        if (c.getPowerLevel((Power)Powers.VERDANT_POWER.get()) > WorldSpecificValue.get("verdant_escape_threshold", 1300, 1500)) {
            SpecialCaseMan.verdantEscape(c);
        }
        if (c.areaMemory.exists(c.m_58904_(), (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.INCOMPLETE_STAFF.get())) {
            SpecialCaseMan.staffCraftStep(c, c.areaMemory.fetch(c.m_58904_(), (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.INCOMPLETE_STAFF.get()));
        }
    }

    public static ItemStack checkBottleSpecialCases(CrucibleBlockEntity c, ItemStack bottle) {
        if (c.enderRiftStrength > 0 && bottle.m_150930_((Item)Registration.WARP_BOTTLE.get())) {
            return SpecialCaseMan.makeRiftBottle(c, bottle);
        }
        return bottle;
    }

    private static void copperCharging(CrucibleBlockEntity c) {
        if (c.electricCharge < 20) {
            c.electricCharge += 2;
        }
    }

    private static void enderEyeFlyAway(CrucibleBlockEntity c, ItemEntity e) {
        ServerLevel serverlevel = (ServerLevel)c.m_58904_();
        BlockPos blockpos = serverlevel.m_207561_(ConfiguredStructureTags.f_207632_, c.m_58899_(), 100, false);
        if (blockpos != null) {
            EyeOfEnder eyeofender = new EyeOfEnder(c.m_58904_(), (double)c.m_58899_().m_123341_(), (double)c.m_58899_().m_123342_(), (double)c.m_58899_().m_123343_());
            eyeofender.m_36972_(e.m_32055_());
            eyeofender.m_36967_(blockpos);
            c.m_58904_().m_7967_((Entity)eyeofender);
            c.m_58904_().m_6263_(null, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.5, (double)c.m_58899_().m_123343_() + 0.5, SoundEvents.f_11898_, SoundSource.NEUTRAL, 0.5f, 0.4f / (c.m_58904_().m_5822_().nextFloat() * 0.4f + 0.8f));
            e.m_32055_().m_41774_(1);
            if (e.m_32055_().m_41613_() < 1) {
                e.m_6074_();
            }
        }
    }

    private static void pumpkinMagic(Level level, ItemEntity e, CrucibleBlockEntity c) {
        if (level.f_46443_ || c.areaMemory.exists(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.IRON_SYMBOL.get())) {
            return;
        }
        BlockPos blazeRodPos = c.areaMemory.fetch(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.BLAZE_ROD.get());
        if (blazeRodPos != null) {
            SpecialCaseMan.conjureBlaze(level, e, c, blazeRodPos);
            return;
        }
        BlockPos candlePos = c.areaMemory.fetch(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), Blocks.f_152482_);
        if (candlePos != null && ((Boolean)level.m_8055_(candlePos).m_61143_((Property)CandleBlock.f_152791_)).booleanValue()) {
            SpecialCaseMan.conjureSpirit(level, e, c, candlePos);
        }
    }

    private static void conjureBlaze(Level level, ItemEntity e, CrucibleBlockEntity c, BlockPos blazeRodPos) {
        EntityType.f_20551_.m_20592_((ServerLevel)level, null, null, blazeRodPos, MobSpawnType.MOB_SUMMONED, true, true);
        e.m_6074_();
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.f_123744_, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.5125, (double)c.m_58899_().m_123343_() + 0.5, (double)blazeRodPos.m_123341_() + 0.5, (double)blazeRodPos.m_123342_() + 0.38, (double)blazeRodPos.m_123343_() + 0.5, 20, 0.01);
        for (int i = 0; i < 10; ++i) {
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)blazeRodPos.m_123341_() + 0.5, (double)blazeRodPos.m_123342_() + 0.38, (double)blazeRodPos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        level.m_5594_(null, blazeRodPos, SoundEvents.f_11705_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void conjureSpirit(Level level, ItemEntity e, CrucibleBlockEntity c, BlockPos candlePos) {
        EntityType.f_20491_.m_20592_((ServerLevel)level, null, null, candlePos, MobSpawnType.MOB_SUMMONED, true, true);
        e.m_6074_();
        ParticleScribe.drawParticleLine(level, (ParticleOptions)ParticleTypes.f_123808_, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.5125, (double)c.m_58899_().m_123343_() + 0.5, (double)candlePos.m_123341_() + 0.5, (double)candlePos.m_123342_() + 0.38, (double)candlePos.m_123343_() + 0.5, 20, 0.01);
        for (int i = 0; i < 10; ++i) {
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123759_, (double)candlePos.m_123341_() + 0.5, (double)candlePos.m_123342_() + 0.38, (double)candlePos.m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        level.m_5594_(null, candlePos, SoundEvents.f_12404_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void enderPearlDissolve(Level l, BlockPos p, ItemEntity e, CrucibleBlockEntity c) {
        float chance = (float)c.getPowerLevel((Power)Powers.WARP_POWER.get()) / 1600.0f;
        if (l.f_46441_.nextFloat() > chance) {
            return;
        }
        for (int i = 0; i < 32; ++i) {
            ((ServerLevel)l).m_8767_((ParticleOptions)ParticleTypes.f_123760_, e.m_20185_(), e.m_20186_() + l.f_46441_.nextDouble() * 2.0, e.m_20189_(), 1, l.f_46441_.nextGaussian(), 0.0, l.f_46441_.nextGaussian(), 0.0);
        }
        boolean foundTarget = false;
        UUID thrower = e.m_32057_();
        if (thrower != null) {
            Player player = l.m_46003_(thrower);
            if (!l.f_46443_) {
                CriteriaTriggers.ENDER_PEARL_DISSOLVE_TRIGGER.trigger((ServerPlayer)player);
            }
            if (player != null && e.m_183503_().m_46472_().equals((Object)player.m_183503_().m_46472_())) {
                player.m_6021_((double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.85, (double)p.m_123343_() + 0.5);
                foundTarget = true;
            }
        }
        if (!foundTarget) {
            FlagCriterion.triggerForNearbyPlayers((ServerLevel)l, CriteriaTriggers.MAKE_RIFT_TRIGGER, p, 20);
            c.enderRiftStrength = 2000;
        }
        e.m_6074_();
    }

    public static boolean tryTeleportNearbyEntity(BlockPos pos, Level level, BlockPos destination, boolean can_teleport_players) {
        AABB aoe = new AABB(pos);
        aoe = aoe.m_82400_((double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue());
        List nearby_ents = Objects.requireNonNull(level).m_45976_(LivingEntity.class, aoe);
        ArrayList<LivingEntity> to_be_excluded = new ArrayList<LivingEntity>();
        for (LivingEntity e : nearby_ents) {
            if (((List)ConfigMan.COMMON.doNotTeleport.get()).contains(e.m_20078_())) {
                to_be_excluded.add(e);
            }
            if (!(e instanceof Player) || can_teleport_players) continue;
            to_be_excluded.add(e);
        }
        nearby_ents.removeAll(to_be_excluded);
        if (!nearby_ents.isEmpty() && CrystalIronItem.effectNotBlocked(level, (LivingEntity)nearby_ents.get(0), (double)level.f_46441_.nextFloat() < 0.02 ? 1 : 0)) {
            ((LivingEntity)nearby_ents.get(0)).m_6021_((double)destination.m_123341_() + 0.5, (double)destination.m_123342_() + 0.85, (double)destination.m_123343_() + 0.5);
            return true;
        }
        return false;
    }

    public static ItemStack makeRiftBottle(CrucibleBlockEntity c, ItemStack bottle) {
        if (bottle.m_41783_() == null) {
            bottle.m_41751_(new CompoundTag());
        }
        WarpBottleItem.addTeleportTags((ResourceKey<Level>)Objects.requireNonNull(c.m_58904_()).m_46472_(), c.m_58899_(), bottle.m_41783_());
        c.enderRiftStrength = 0;
        return bottle;
    }

    private static void explodeGunpowderDueToBlaze(Level l, BlockPos p, ItemEntity e) {
        l.m_46511_((Entity)e, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, 1.0f, Explosion.BlockInteraction.NONE);
        e.m_6074_();
    }

    private static void waterWriting(CrucibleBlockEntity c, ItemEntity e) {
        if (c.getPowerLevel((Power)Powers.MIND_POWER.get()) < WorldSpecificValue.get("water_write_threshold", WorldSpecificValue.get("water_write_cost", 20, 50), 700)) {
            return;
        }
        String CHAR_LIST = "abcdefhijklmnopqstuvwxyz, -;6'";
        CompoundTag book_tag = e.m_32055_().m_41783_();
        if (book_tag == null) {
            e.m_32055_().m_41700_("pages", (Tag)new ListTag());
            book_tag = e.m_32055_().m_41783_();
        }
        ListTag pages = book_tag.m_128437_("pages", 8);
        int pagecount = Math.max(c.getPowerLevel((Power)Powers.MIND_POWER.get()) / 220, pages.size());
        for (int i = 0; i < pagecount; ++i) {
            StringBuilder gibberish = new StringBuilder();
            for (int j = 0; j < 200; ++j) {
                gibberish.append(CHAR_LIST.charAt(e.f_19853_.f_46441_.nextInt(CHAR_LIST.length())));
            }
            if (i < pages.size()) {
                pages.set(i, (Tag)StringTag.m_129297_((String)gibberish.toString()));
                continue;
            }
            pages.add(i, (Tag)StringTag.m_129297_((String)gibberish.toString()));
        }
        e.f_19853_.m_5594_(null, c.m_58899_(), SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, 1.0f);
        e.f_19853_.m_5594_(null, c.m_58899_(), SoundEvents.f_11887_, SoundSource.BLOCKS, 0.7f, 0.7f);
        c.expendPower((Power)Powers.MIND_POWER.get(), WorldSpecificValue.get("water_write_cost", 20, 50));
        c.setDirty();
    }

    private static void residualSlime(CrucibleBlockEntity c, ItemEntity e) {
        c.expendPower((Power)Powers.VERDANT_POWER.get(), 400);
        c.setDirty();
        if (e.m_32055_().m_41613_() == 1) {
            e.m_6074_();
        } else {
            e.m_32055_().m_41774_(1);
        }
        Slime slime = new Slime(EntityType.f_20526_, Objects.requireNonNull(c.m_58904_()));
        slime.m_146884_(Vec3.m_82512_((Vec3i)c.m_58899_()).m_82520_(0.0, 0.1, 0.0));
        c.m_58904_().m_7967_((Entity)slime);
    }

    private static void soulEscape(CrucibleBlockEntity c) {
        if (c.m_58904_() == null) {
            return;
        }
        if (c.m_58904_().m_5776_()) {
            c.m_58904_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.65, (double)c.m_58899_().m_123343_() + 0.5, 0.0, 0.0, 0.0);
        } else {
            ((ServerLevel)c.m_58904_()).m_8767_((ParticleOptions)ParticleTypes.f_123746_, (double)c.m_58899_().m_123341_() + 0.5, (double)c.m_58899_().m_123342_() + 0.65, (double)c.m_58899_().m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void curseEscape(CrucibleBlockEntity c) {
        if (c.m_58904_() == null) {
            return;
        }
        AABB aoe = new AABB(c.m_58899_());
        aoe = aoe.m_82400_(5.0);
        if (!c.m_58904_().m_5776_()) {
            if (c.getPowerLevel((Power)Powers.CURSE_POWER.get()) > 1400) {
                Object m = (double)c.m_58904_().m_5822_().nextFloat() < 0.35 ? new Skeleton(EntityType.f_20524_, c.m_58904_()) : new Zombie(EntityType.f_20501_, c.m_58904_());
                m.m_20225_(true);
                m.m_146884_(aoe.m_82399_().m_82520_((double)WorldSpecificValue.get("monster_summon_x", -5, 5), 1.0, (double)WorldSpecificValue.get("monster_summon_z", -5, 5)));
                c.m_58904_().m_7967_((Entity)m);
            }
            List nearby_ents = c.m_58904_().m_45976_(LivingEntity.class, aoe);
            for (LivingEntity e : nearby_ents) {
                if (e.m_6336_().equals(MobType.f_21641_)) continue;
                e.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 300, 0));
                e.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 200, 0));
                e.m_6469_(DamageSource.f_19319_, 10.0f);
                if (!(e instanceof Player)) continue;
                CriteriaTriggers.BE_CURSED_TRIGGER.trigger((ServerPlayer)e);
            }
            c.m_58904_().m_5594_(null, c.m_58899_(), SoundEvents.f_11689_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void blazeEscape(CrucibleBlockEntity c) {
        if (c.m_58904_() == null) {
            return;
        }
        AABB blast_zone = new AABB(c.m_58899_());
        blast_zone.m_82377_(1.5, 3.0, 1.5);
        if (!c.m_58904_().m_5776_()) {
            List nearby_ents = c.m_58904_().m_45976_(LivingEntity.class, blast_zone);
            for (LivingEntity e : nearby_ents) {
                e.m_6469_(DamageSource.f_19305_, 12.0f);
                e.m_20254_(3);
            }
            c.m_58904_().m_5594_(null, c.m_58899_(), SoundEvents.f_11705_, SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 10; ++i) {
                if (c.getPowerLevel((Power)Powers.SOUL_POWER.get()) > 20) {
                    ParticleScribe.drawParticleCrucibleTop(c.m_58904_(), (ParticleOptions)ParticleTypes.f_123745_, c.m_58899_(), 1.0f, 0.0, 1.0, 0.0);
                    continue;
                }
                ParticleScribe.drawParticleCrucibleTop(c.m_58904_(), (ParticleOptions)ParticleTypes.f_123744_, c.m_58899_(), 1.0f, 0.0, 1.0, 0.0);
            }
        }
    }

    private static void verdantEscape(CrucibleBlockEntity c) {
        if (c.m_58904_() == null || c.m_58904_().f_46443_ || WorldSpecificValue.getBool("no_moss", 0.5f)) {
            return;
        }
        ((MossBlock)Blocks.f_152544_).m_7719_((ServerLevel)c.m_58904_(), c.m_58904_().f_46441_, c.m_58899_().m_7495_(), c.m_58900_());
    }

    public static void solidifyPortal(Level l, BlockPos p, Direction.Axis axis) {
        HyperPortalShape portal = new HyperPortalShape((LevelAccessor)l, p, axis);
        if (portal.isComplete()) {
            portal.createSolidPortalBlocks();
            if (!l.f_46443_) {
                FlagCriterion.triggerForNearbyPlayers((ServerLevel)l, CriteriaTriggers.PORTAL_FREEZE_TRIGGER, p, 9);
            }
        }
    }

    public static void staffCraftStep(CrucibleBlockEntity c, BlockPos staff_pos) {
        for (Power p : c.getPowerMap().keySet()) {
            if (c.getPowerLevel(p) <= 800) continue;
            IncompleteStaffBlock.tryMakeProgress(Objects.requireNonNull(c.m_58904_()), c.m_58904_().m_8055_(staff_pos), staff_pos, p);
        }
    }
}

