/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.alchemy.rxn;

import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.WorldSpecificValues;
import com.hyperlynx.reactive.alchemy.rxn.EffectReaction;
import com.hyperlynx.reactive.be.CrucibleBlockEntity;
import com.hyperlynx.reactive.fx.ParticleScribe;
import java.util.function.Function;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;

public class AnnihilationReaction
extends EffectReaction {
    public AnnihilationReaction(String alias, Power p1, Power p2, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Function<CrucibleBlockEntity, CrucibleBlockEntity> render) {
        super(alias, function, render, 0);
        this.reagents.put(p1, WorldSpecificValues.ANNIHILATION_THRESHOLD.get());
        this.reagents.put(p2, WorldSpecificValues.ANNIHILATION_THRESHOLD.get());
    }

    @Override
    public void render(Level l, CrucibleBlockEntity crucible) {
        this.renderFunction.apply(crucible);
        ParticleScribe.drawParticleCrucibleTop(l, (ParticleOptions)ParticleTypes.f_123762_, crucible.m_58899_(), 0.2f);
    }

    @Override
    public boolean conditionsMet(CrucibleBlockEntity crucible) {
        return super.conditionsMet(crucible) && crucible.getTotalPowerLevel() > WorldSpecificValues.ANNIHILATION_THRESHOLD.get();
    }

    @Override
    public String toString() {
        return super.toString() + " - annihilation reaction";
    }
}

