/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.alchemy.rxn;

import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.Powers;
import com.hyperlynx.reactive.alchemy.WorldSpecificValues;
import com.hyperlynx.reactive.alchemy.rxn.Reaction;
import com.hyperlynx.reactive.be.CrucibleBlockEntity;
import com.hyperlynx.reactive.fx.ParticleScribe;
import com.hyperlynx.reactive.items.CrystalIronItem;
import com.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class CurseAssimilationReaction
extends Reaction {
    int rate = WorldSpecificValues.CURSE_RATE.get();

    public CurseAssimilationReaction(String alias) {
        super(alias, 0);
    }

    @Override
    public void run(CrucibleBlockEntity crucible) {
        crucible.expendAnyPowerExcept((Power)Powers.CURSE_POWER.get(), this.rate);
        crucible.addPower((Power)Powers.CURSE_POWER.get(), this.rate);
        if ((double)Objects.requireNonNull(crucible.m_58904_()).f_46441_.nextFloat() < 0.2 && crucible.getPowerLevel((Power)Powers.CURSE_POWER.get()) > WorldSpecificValue.get("curse_assim_hurt_threshold", 900, 1100)) {
            AABB aoe = new AABB(crucible.m_58899_());
            aoe = aoe.m_82400_(3.0);
            List nearby_ents = crucible.m_58904_().m_45976_(LivingEntity.class, aoe);
            for (LivingEntity e : nearby_ents) {
                if (!CrystalIronItem.effectNotBlocked(crucible.m_58904_(), e, 1)) continue;
                e.m_6469_(DamageSource.f_19319_, 1.0f);
            }
        }
    }

    @Override
    public void render(Level l, CrucibleBlockEntity crucible) {
        ParticleScribe.drawParticleRing(l, (ParticleOptions)ParticleTypes.f_123783_, crucible.m_58899_(), 0.45, 0.7, 1);
    }

    @Override
    public boolean conditionsMet(CrucibleBlockEntity crucible) {
        boolean has_curse = crucible.getPowerLevel((Power)Powers.CURSE_POWER.get()) > this.rate;
        return crucible.getTotalPowerLevel() > crucible.getPowerLevel((Power)Powers.CURSE_POWER.get()) + this.rate && has_curse;
    }
}

