/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.alchemy.rxn;

import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.rxn.Reaction;
import com.hyperlynx.reactive.be.CrucibleBlockEntity;
import com.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.function.Function;
import net.minecraft.world.level.Level;

public class EffectReaction
extends Reaction {
    protected Function<CrucibleBlockEntity, CrucibleBlockEntity> effectFunction;
    protected Function<CrucibleBlockEntity, CrucibleBlockEntity> renderFunction;
    int cost;

    public EffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> effect, Function<CrucibleBlockEntity, CrucibleBlockEntity> render, int numReagents) {
        super(alias, numReagents);
        this.effectFunction = effect;
        this.renderFunction = render;
        this.cost = WorldSpecificValue.get(alias + "cost", 10, 30);
    }

    public EffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Function<CrucibleBlockEntity, CrucibleBlockEntity> render, Power required_power) {
        super(alias, 0);
        this.effectFunction = function;
        this.renderFunction = render;
        this.cost = WorldSpecificValue.get(alias + "cost", 1, 50);
        this.reagents.put(required_power, WorldSpecificValue.get(alias + "required", 1, 400));
    }

    public EffectReaction(String alias, Function<CrucibleBlockEntity, CrucibleBlockEntity> function, Function<CrucibleBlockEntity, CrucibleBlockEntity> render, Power required_power, int num_additionals) {
        super(alias, num_additionals);
        this.effectFunction = function;
        this.renderFunction = render;
        this.cost = WorldSpecificValue.get(alias + "cost", 1, 50);
        this.reagents.put(required_power, WorldSpecificValue.get(alias + "required", 1, 400));
    }

    @Override
    public void run(CrucibleBlockEntity crucible) {
        if (this.effectFunction != null) {
            this.effectFunction.apply(crucible);
        }
        for (Power p : this.reagents.keySet()) {
            crucible.expendPower(p, (int)((double)this.cost / (double)this.reagents.size()) + 1);
            crucible.setDirty();
        }
    }

    @Override
    public void render(Level l, CrucibleBlockEntity crucible) {
        if (this.renderFunction != null) {
            this.renderFunction.apply(crucible);
        }
    }

    @Override
    public String toString() {
        return super.toString() + " - effect reaction";
    }
}

