/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.alchemy.rxn;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.Powers;
import com.hyperlynx.reactive.alchemy.rxn.ReactionMan;
import com.hyperlynx.reactive.be.CrucibleBlockEntity;
import com.hyperlynx.reactive.util.ConfigMan;
import com.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;

public abstract class Reaction {
    protected HashMap<Power, Integer> reagents = new HashMap();
    protected Stimulus stimulus = Stimulus.NONE;

    public Reaction(String alias, int max_reagent_count) {
        int reagent_count = max_reagent_count < 3 ? max_reagent_count : WorldSpecificValue.get(alias + "reagent_count", 2, max_reagent_count);
        int i = 0;
        while (this.reagents.size() < reagent_count) {
            Power chosen_power = WorldSpecificValue.getFromCollection(alias + "r" + i, ReactionMan.BASE_POWER_LIST);
            int min = WorldSpecificValue.get(alias + "r" + i, 1, 400);
            this.reagents.put(chosen_power, min);
            ++i;
        }
    }

    public Reaction(String alias, Power ... powers) {
        for (Power p : powers) {
            this.reagents.put(p, WorldSpecificValue.get(alias + p.getName(), 1, 400));
        }
    }

    public Reaction setStimulus(Stimulus rxs) {
        this.stimulus = rxs;
        return this;
    }

    public boolean conditionsMet(CrucibleBlockEntity crucible) {
        if (WorldSpecificValue.get("body_inhibition_threshold", 200, 500) < crucible.getPowerLevel((Power)Powers.BODY_POWER.get())) {
            return false;
        }
        for (Power p : this.reagents.keySet()) {
            if (p.checkReactivity(crucible.getPowerLevel(p), this.reagents.get(p))) continue;
            return false;
        }
        return this.checkStimulus(crucible);
    }

    private boolean checkStimulus(CrucibleBlockEntity crucible) {
        return switch (this.stimulus) {
            case Stimulus.END_CRYSTAL -> this.checkEndCrystal(crucible);
            case Stimulus.GOLD_SYMBOL -> crucible.areaMemory.exists(crucible.m_58904_(), (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.GOLD_SYMBOL.get());
            case Stimulus.ELECTRIC -> {
                if (crucible.electricCharge > 0) {
                    yield true;
                }
                yield false;
            }
            case Stimulus.NO_ELECTRIC -> {
                if (crucible.electricCharge == 0) {
                    yield true;
                }
                yield false;
            }
            case Stimulus.SACRIFICE -> {
                if (crucible.sacrificeCount >= 10) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private boolean checkEndCrystal(CrucibleBlockEntity crucible) {
        Level level = crucible.m_58904_();
        if (crucible.linked_crystal != null && !crucible.linked_crystal.m_146910_()) {
            crucible.used_crystal_this_cycle = true;
            return true;
        }
        if (level.f_46443_) {
            return false;
        }
        if (((ServerLevel)level).m_8586_() != null) {
            return false;
        }
        int range = (Integer)ConfigMan.COMMON.crucibleRange.get();
        AABB aoe = new AABB(crucible.m_58899_().m_142082_(-range, -range, -range), crucible.m_58899_().m_142082_(range, range, range));
        List end_crystals = level.m_45976_(EndCrystal.class, aoe);
        if (end_crystals.isEmpty()) {
            return false;
        }
        ((EndCrystal)end_crystals.get(0)).m_31052_(crucible.m_58899_().m_6625_(2));
        crucible.linked_crystal = (EndCrystal)end_crystals.get(0);
        crucible.used_crystal_this_cycle = true;
        return true;
    }

    public abstract void run(CrucibleBlockEntity var1);

    public abstract void render(Level var1, CrucibleBlockEntity var2);

    public String toString() {
        return this.reagents.toString();
    }

    public static enum Stimulus {
        NONE,
        GOLD_SYMBOL,
        ELECTRIC,
        NO_ELECTRIC,
        SACRIFICE,
        END_CRYSTAL,
        NO_END_CRYSTAL;

    }
}

