/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.alchemy.rxn;

import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.Powers;
import com.hyperlynx.reactive.alchemy.WorldSpecificValues;
import com.hyperlynx.reactive.alchemy.rxn.AnnihilationReaction;
import com.hyperlynx.reactive.alchemy.rxn.AssimilationReaction;
import com.hyperlynx.reactive.alchemy.rxn.CurseAssimilationReaction;
import com.hyperlynx.reactive.alchemy.rxn.DecomposeReaction;
import com.hyperlynx.reactive.alchemy.rxn.EffectReaction;
import com.hyperlynx.reactive.alchemy.rxn.FreeEffectReaction;
import com.hyperlynx.reactive.alchemy.rxn.Reaction;
import com.hyperlynx.reactive.alchemy.rxn.ReactionEffects;
import com.hyperlynx.reactive.alchemy.rxn.SynthesisReaction;
import com.hyperlynx.reactive.fx.ReactionRenders;
import com.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ReactionMan {
    static boolean initialized = false;
    private static final LinkedList<Reaction> REACTIONS = new LinkedList();
    public static ArrayList<Power> BASE_POWER_LIST = new ArrayList();

    public List<Reaction> getReactions() {
        return initialized ? REACTIONS : this.constructReactions();
    }

    public boolean isInitialized() {
        return initialized;
    }

    private LinkedList<Reaction> constructReactions() {
        BASE_POWER_LIST.add((Power)Powers.BLAZE_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.WARP_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.SOUL_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.LIGHT_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.MIND_POWER.get());
        BASE_POWER_LIST.add((Power)Powers.VITAL_POWER.get());
        BASE_POWER_LIST = WorldSpecificValue.shuffle("power_list_order", BASE_POWER_LIST);
        REACTIONS.add(new CurseAssimilationReaction("curse_assimilation"));
        REACTIONS.add(new AssimilationReaction("vital_kill", (Power)Powers.ACID_POWER.get(), (Power)Powers.VITAL_POWER.get()));
        REACTIONS.add(new AssimilationReaction("vital_eat", (Power)Powers.VITAL_POWER.get(), (Power)Powers.BODY_POWER.get()));
        switch (WorldSpecificValues.VERDANT_VITAL_RELATIONSHIP.get()) {
            case 2: {
                REACTIONS.add(new AssimilationReaction("verdant_consume", (Power)Powers.VERDANT_POWER.get(), (Power)Powers.VITAL_POWER.get()));
                break;
            }
            case 3: {
                REACTIONS.add(new AssimilationReaction("vital_consume", (Power)Powers.VITAL_POWER.get(), (Power)Powers.VERDANT_POWER.get()));
                break;
            }
            case 4: {
                REACTIONS.add(new SynthesisReaction("verdant_growth", (Power)Powers.VERDANT_POWER.get(), new Power[]{(Power)Powers.VITAL_POWER.get(), (Power)Powers.LIGHT_POWER.get()}));
                break;
            }
            case 5: {
                REACTIONS.add(new SynthesisReaction("vital_growth", (Power)Powers.VITAL_POWER.get(), new Power[]{(Power)Powers.VERDANT_POWER.get(), (Power)Powers.LIGHT_POWER.get()}));
            }
        }
        REACTIONS.add(new AnnihilationReaction("annihilation0v3", BASE_POWER_LIST.get(0), BASE_POWER_LIST.get(3), ReactionEffects::discharge, null));
        REACTIONS.add(new AnnihilationReaction("annihilation1v4", BASE_POWER_LIST.get(1), BASE_POWER_LIST.get(4), ReactionEffects::smoke, ReactionRenders::smoke));
        REACTIONS.add(new AnnihilationReaction("annihilation2v5", BASE_POWER_LIST.get(2), BASE_POWER_LIST.get(5), ReactionEffects::salt, null));
        REACTIONS.add(new SynthesisReaction("x_synthesis", (Power)Powers.X_POWER.get(), new Power[]{BASE_POWER_LIST.get(0), BASE_POWER_LIST.get(1)}).setStimulus(Reaction.Stimulus.ELECTRIC));
        REACTIONS.add(new SynthesisReaction("y_synthesis", (Power)Powers.Y_POWER.get(), new Power[]{BASE_POWER_LIST.get(2), BASE_POWER_LIST.get(3)}).setStimulus(Reaction.Stimulus.ELECTRIC));
        REACTIONS.add(new SynthesisReaction("z_synthesis", (Power)Powers.Z_POWER.get(), new Power[]{BASE_POWER_LIST.get(4), BASE_POWER_LIST.get(5)}).setStimulus(Reaction.Stimulus.ELECTRIC));
        REACTIONS.add(new EffectReaction("growth_effect", ReactionEffects::growth, ReactionRenders::growth, (Power)Powers.VERDANT_POWER.get(), 1).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
        REACTIONS.add(new FreeEffectReaction("flames_effect", ReactionEffects::flamethrower, ReactionRenders::flamethrower, (Power)Powers.BLAZE_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
        REACTIONS.add(new FreeEffectReaction("levitation", ReactionEffects::levitation, null, (Power)Powers.LIGHT_POWER.get()).setStimulus(Reaction.Stimulus.END_CRYSTAL));
        switch (WorldSpecificValues.CONDUIT_POWER.get()) {
            case 1: {
                REACTIONS.add(new DecomposeReaction("soul_to_warp", (Power)Powers.SOUL_POWER.get(), new Power[]{(Power)Powers.WARP_POWER.get()}).setStimulus(Reaction.Stimulus.END_CRYSTAL));
                break;
            }
            case 2: {
                REACTIONS.add(new DecomposeReaction("warp_to_soul", (Power)Powers.WARP_POWER.get(), new Power[]{(Power)Powers.SOUL_POWER.get()}).setStimulus(Reaction.Stimulus.END_CRYSTAL));
            }
        }
        int order = WorldSpecificValues.EFFECT_ORDER.get();
        switch (order) {
            case 1: {
                REACTIONS.add(new DecomposeReaction("compound_degradation", (Power)Powers.X_POWER.get(), new Power[]{BASE_POWER_LIST.get(0), BASE_POWER_LIST.get(1)}).setStimulus(Reaction.Stimulus.NO_ELECTRIC));
                REACTIONS.add(new EffectReaction("explosion_effect", ReactionEffects::explosion, null, (Power)Powers.X_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
                REACTIONS.add(new EffectReaction("formation_effect", ReactionEffects::foaming, ReactionRenders::foaming, (Power)Powers.Y_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
                REACTIONS.add(new EffectReaction("block_fall_effect", ReactionEffects::blockfall, null, (Power)Powers.Z_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
                break;
            }
            case 2: {
                REACTIONS.add(new DecomposeReaction("compound_degradation", (Power)Powers.Y_POWER.get(), new Power[]{BASE_POWER_LIST.get(2), BASE_POWER_LIST.get(3)}).setStimulus(Reaction.Stimulus.NO_ELECTRIC));
                REACTIONS.add(new EffectReaction("explosion_effect", ReactionEffects::explosion, null, (Power)Powers.Y_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
                REACTIONS.add(new EffectReaction("formation_effect", ReactionEffects::foaming, ReactionRenders::foaming, (Power)Powers.Z_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
                REACTIONS.add(new EffectReaction("block_fall_effect", ReactionEffects::blockfall, null, (Power)Powers.X_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
                break;
            }
            case 3: {
                REACTIONS.add(new DecomposeReaction("compound_degradation", (Power)Powers.Z_POWER.get(), new Power[]{BASE_POWER_LIST.get(4), BASE_POWER_LIST.get(5)}).setStimulus(Reaction.Stimulus.NO_ELECTRIC));
                REACTIONS.add(new EffectReaction("explosion_effect", ReactionEffects::explosion, null, (Power)Powers.Z_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
                REACTIONS.add(new EffectReaction("formation_effect", ReactionEffects::foaming, ReactionRenders::foaming, (Power)Powers.X_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
                REACTIONS.add(new EffectReaction("block_fall_effect", ReactionEffects::blockfall, null, (Power)Powers.Y_POWER.get()).setStimulus(Reaction.Stimulus.GOLD_SYMBOL));
            }
        }
        REACTIONS.add(new DecomposeReaction("necromancy", (Power)Powers.SOUL_POWER.get(), new Power[]{(Power)Powers.CURSE_POWER.get()}).setStimulus(Reaction.Stimulus.SACRIFICE));
        initialized = true;
        return REACTIONS;
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        this.reset();
    }

    public void reset() {
        initialized = false;
        REACTIONS.clear();
        BASE_POWER_LIST.clear();
    }
}

