/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.alchemy.rxn;

import com.hyperlynx.reactive.advancements.CriteriaTriggers;
import com.hyperlynx.reactive.advancements.FlagCriterion;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.rxn.Reaction;
import com.hyperlynx.reactive.be.CrucibleBlockEntity;
import com.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class SynthesisReaction
extends Reaction {
    Power resultPower;
    int rate;

    public SynthesisReaction(String alias, Power resultPower, Power ... reagents) {
        super(alias, reagents);
        this.rate = WorldSpecificValue.get(alias + "rate", 40, 100);
        this.resultPower = resultPower;
    }

    @Override
    public void run(CrucibleBlockEntity crucible) {
        for (Power p : this.reagents.keySet()) {
            crucible.expendPower(p, (int)Math.ceil((double)this.rate / (double)this.reagents.size()));
        }
        crucible.addPower(this.resultPower, this.rate);
        if (!Objects.requireNonNull(crucible.m_58904_()).f_46443_) {
            FlagCriterion.triggerForNearbyPlayers((ServerLevel)crucible.m_58904_(), CriteriaTriggers.SEE_SYNTHESIS_TRIGGER, crucible.m_58899_(), 8);
        }
    }

    @Override
    public void render(Level l, CrucibleBlockEntity crucible) {
    }

    @Override
    public String toString() {
        return super.toString() + " - synthesis reaction";
    }
}

