/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.be;

import com.hyperlynx.reactive.ReactiveMod;
import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.advancements.CriteriaTriggers;
import com.hyperlynx.reactive.advancements.FlagCriterion;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.PowerBearer;
import com.hyperlynx.reactive.alchemy.Powers;
import com.hyperlynx.reactive.alchemy.SpecialCaseMan;
import com.hyperlynx.reactive.alchemy.WorldSpecificValues;
import com.hyperlynx.reactive.alchemy.rxn.Reaction;
import com.hyperlynx.reactive.blocks.CrucibleBlock;
import com.hyperlynx.reactive.fx.ParticleScribe;
import com.hyperlynx.reactive.recipes.DissolveRecipe;
import com.hyperlynx.reactive.recipes.PrecipitateRecipe;
import com.hyperlynx.reactive.recipes.TransmuteRecipe;
import com.hyperlynx.reactive.util.AreaMemory;
import com.hyperlynx.reactive.util.BeamHelper;
import com.hyperlynx.reactive.util.Color;
import com.hyperlynx.reactive.util.ConfigMan;
import com.hyperlynx.reactive.util.FakeContainer;
import com.hyperlynx.reactive.util.WorldSpecificValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ConduitBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class CrucibleBlockEntity
extends BlockEntity
implements PowerBearer {
    public static final int CRUCIBLE_MAX_POWER = 1600;
    private final HashMap<Power, Integer> powers = new HashMap();
    public AreaMemory areaMemory;
    private int tick_counter = 0;
    private int process_stage = 0;
    private int gather_stage = 0;
    private final Color mix_color = new Color();
    public boolean color_changed = true;
    private final Color next_mix_color = new Color();
    private boolean color_initialized = false;
    public int electricCharge = 0;
    public int sacrificeCount = 0;
    public int enderRiftStrength = 0;
    public EndCrystal linked_crystal = null;
    public boolean used_crystal_this_cycle = false;

    public CrucibleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.CRUCIBLE_BE_TYPE.get(), pos, state);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.areaMemory = new AreaMemory(pos);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        ++crucible.tick_counter;
        if (!level.f_46443_ && crucible.enderRiftStrength > 0) {
            crucible.enderRiftStrength = SpecialCaseMan.tryTeleportNearbyEntity(crucible.m_58899_(), crucible.m_58904_(), crucible.m_58899_(), true) ? 0 : crucible.enderRiftStrength - 1;
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5625 + level.f_46441_.nextDouble() * 2.0, (double)pos.m_123343_() + 0.5, 1, level.f_46441_.nextGaussian(), 0.0, level.f_46441_.nextGaussian(), 0.0);
        }
        if (crucible.tick_counter >= (Integer)ConfigMan.COMMON.crucibleTickDelay.get()) {
            crucible.tick_counter = 1;
            if (!((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) {
                CrucibleBlockEntity.empty(level, pos, state, crucible);
            }
            switch (crucible.process_stage) {
                case 0: {
                    if (level.m_8055_(pos.m_7495_()).m_60713_((Block)Registration.VOLT_CELL.get()) && crucible.electricCharge < 15) {
                        crucible.electricCharge = 15;
                    } else if (crucible.electricCharge > 0) {
                        --crucible.electricCharge;
                    }
                    if (level.m_5776_() || ((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue() || !crucible.areaMemory.existsAbove(crucible.f_58857_, (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.WARP_SPONGE.get())) break;
                    crucible.m_58904_().m_7731_(crucible.m_58899_(), (BlockState)level.m_8055_(crucible.m_58899_()).m_61124_((Property)CrucibleBlock.FULL, (Comparable)Boolean.valueOf(true)), 2);
                    level.m_5594_(null, pos, SoundEvents.f_11781_, SoundSource.BLOCKS, 0.6f, 1.0f);
                    break;
                }
                case 1: {
                    if (level.m_5776_() || !((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) break;
                    CrucibleBlockEntity.gatherPower(level, crucible);
                    break;
                }
                case 2: {
                    if (level.m_5776_() || !((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue() || !CrucibleBlockEntity.processItemsInside(level, pos, state, crucible)) break;
                    level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 0.65f + level.m_5822_().nextFloat() / 5.0f);
                    break;
                }
                case 3: {
                    if (level.m_5776_() || !((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) break;
                    CrucibleBlockEntity.react(level, crucible);
                    break;
                }
                case 4: {
                    crucible.setDirty();
                    crucible.process_stage = -1;
                    break;
                }
                default: {
                    System.err.println("Crucible ran out of steps! This can't be!");
                }
            }
            ++crucible.process_stage;
        }
    }

    public static void empty(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        if (crucible.getTotalPowerLevel() > 0) {
            SpecialCaseMan.checkEmptySpecialCases(crucible);
            crucible.expendPower();
            crucible.resetColor();
            crucible.setDirty(level, pos, state);
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.6f, 1.0f);
        }
        if (crucible.linked_crystal != null) {
            crucible.unlinkCrystal(level, pos, state);
        }
    }

    private void unlinkCrystal(Level level, BlockPos pos, BlockState state) {
        this.linked_crystal.m_31052_(null);
        this.linked_crystal = null;
        this.setDirty(level, pos, state);
    }

    private static void gatherPower(Level level, CrucibleBlockEntity crucible) {
        if (crucible.areaMemory.exists(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.COPPER_SYMBOL.get()) && !crucible.areaMemory.exists(level, 3, (Block)Registration.IRON_SYMBOL.get())) {
            switch (crucible.gather_stage) {
                case 0: {
                    if (!crucible.areaMemory.exists(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), Blocks.f_50142_) || crucible.getTotalPowerLevel() <= 400) break;
                    if (crucible.getPowerLevel((Power)Powers.MIND_POWER.get()) > 1300) {
                        BlockPos portal_pos = crucible.areaMemory.fetch(crucible.f_58857_, (Integer)ConfigMan.COMMON.crucibleRange.get(), Blocks.f_50142_);
                        SpecialCaseMan.solidifyPortal(crucible.f_58857_, portal_pos, (Direction.Axis)crucible.f_58857_.m_8055_(portal_pos).m_61143_((Property)NetherPortalBlock.f_54904_));
                        crucible.f_58857_.m_5594_(null, portal_pos, SoundEvents.f_12644_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    crucible.expendAnyPowerExcept(null, 400);
                    FlagCriterion.triggerForNearbyPlayers((ServerLevel)level, CriteriaTriggers.PORTAL_TRADE_TRIGGER, crucible.m_58899_(), (Integer)ConfigMan.COMMON.crucibleRange.get());
                    break;
                }
                case 1: {
                    if (!crucible.areaMemory.exists(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.BLAZE_ROD.get())) break;
                    crucible.addPower((Power)Powers.BLAZE_POWER.get(), WorldSpecificValue.get("blaze_rod_power_amount", 20, 50));
                    break;
                }
                case 2: {
                    if (!crucible.areaMemory.exists(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), Blocks.f_50489_)) break;
                    crucible.addPower((Power)Powers.LIGHT_POWER.get(), WorldSpecificValue.get("end_rod_power_amount", 30, 100));
                    break;
                }
                case 3: {
                    if (!crucible.areaMemory.exists(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.OCCULT_SYMBOL.get()) && !crucible.areaMemory.exists(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), Blocks.f_50312_) && !crucible.areaMemory.exists(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), Blocks.f_50313_)) break;
                    crucible.addPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValue.get("wither_skull_power_amount", 50, 400));
                    break;
                }
                case 4: {
                    Optional maybe_conduit;
                    if (!crucible.areaMemory.exists(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), Blocks.f_50569_) || !(maybe_conduit = level.m_141902_(crucible.areaMemory.fetch(level, (Integer)ConfigMan.COMMON.crucibleRange.get(), Blocks.f_50569_), BlockEntityType.f_58941_)).isPresent() || !((ConduitBlockEntity)maybe_conduit.get()).m_59216_()) break;
                    if (WorldSpecificValues.CONDUIT_POWER.get() == 1) {
                        crucible.addPower((Power)Powers.SOUL_POWER.get(), WorldSpecificValue.get("conduit_power_amount", 120, 140));
                        break;
                    }
                    crucible.addPower((Power)Powers.WARP_POWER.get(), WorldSpecificValue.get("conduit_power_amount", 120, 140));
                    break;
                }
                case 5: {
                    if (crucible.enderRiftStrength > 0) {
                        crucible.addPower((Power)Powers.WARP_POWER.get(), 10);
                    }
                    crucible.gather_stage = -1;
                }
            }
            ++crucible.gather_stage;
        }
        if (level.m_45527_(crucible.m_58899_()) && level.m_46758_(crucible.m_58899_())) {
            crucible.expendAnyPowerExcept((Power)Powers.CURSE_POWER.get(), 80);
        }
    }

    private static void react(Level level, CrucibleBlockEntity crucible) {
        crucible.used_crystal_this_cycle = false;
        for (Reaction r : ReactiveMod.REACTION_MAN.getReactions()) {
            if (!r.conditionsMet(crucible)) continue;
            r.run(crucible);
            crucible.setDirty();
        }
        if (!crucible.used_crystal_this_cycle && crucible.linked_crystal != null) {
            crucible.unlinkCrystal(level, crucible.m_58899_(), crucible.m_58900_());
        }
    }

    private static boolean processItemsInside(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        if (!((Boolean)state.m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) {
            return false;
        }
        boolean changed = false;
        for (Entity entity_inside : CrucibleBlock.getEntitesInside(pos, level)) {
            if (!(entity_inside instanceof ItemEntity)) continue;
            SpecialCaseMan.checkDissolveSpecialCases(crucible, (ItemEntity)entity_inside);
            if (!entity_inside.m_6084_()) continue;
            changed = changed || CrucibleBlockEntity.tryTransmute(level, pos, state, crucible, (ItemEntity)entity_inside);
            boolean bl = changed = changed || CrucibleBlockEntity.tryReduceToPower(((ItemEntity)entity_inside).m_32055_(), crucible);
            if (((ItemEntity)entity_inside).m_32055_().m_41613_() != 0) continue;
            entity_inside.m_142687_(Entity.RemovalReason.KILLED);
        }
        changed = changed || CrucibleBlockEntity.tryPrecipitate(level, pos, state, crucible);
        return changed;
    }

    public static boolean tryReduceToPower(ItemStack stack, CrucibleBlockEntity crucible) {
        List<Power> stack_power_list = Power.getSourcePower(stack);
        boolean changed = false;
        if (stack_power_list.isEmpty()) {
            boolean dissolved = CrucibleBlockEntity.tryDissolveWithByproduct(Objects.requireNonNull(crucible.m_58904_()), crucible.m_58899_(), stack, stack.m_41613_());
            if (dissolved) {
                stack.m_41764_(0);
            }
            return false;
        }
        for (Power p : stack_power_list) {
            int dissolve_capacity = (1600 - crucible.getPowerLevel(p)) / Power.getSourceLevel(stack);
            if (dissolve_capacity <= 0) continue;
            changed = changed || crucible.addPower(p, stack.m_41613_() * Power.getSourceLevel(stack) / stack_power_list.size());
            CrucibleBlockEntity.tryDissolveWithByproduct(Objects.requireNonNull(crucible.m_58904_()), crucible.m_58899_(), stack, Math.min(stack.m_41613_(), dissolve_capacity));
            stack.m_41764_(Math.max(stack.m_41613_() - dissolve_capacity, 0));
        }
        return changed;
    }

    private static boolean tryDissolveWithByproduct(Level level, BlockPos pos, ItemStack stack, int count) {
        List purify_recipes = level.m_7465_().m_44013_((RecipeType)Registration.DISSOLVE_RECIPE_TYPE.get());
        for (DissolveRecipe r : purify_recipes) {
            if (!r.m_5818_(new FakeContainer(stack), level)) continue;
            ItemStack reactant = stack.m_41777_();
            reactant.m_41764_(count);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, r.m_5874_(new FakeContainer(reactant))));
            return true;
        }
        return false;
    }

    private static boolean tryTransmute(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible, ItemEntity itemEntity) {
        List purify_recipes = level.m_7465_().m_44013_((RecipeType)Registration.TRANS_RECIPE_TYPE.get());
        for (TransmuteRecipe r : purify_recipes) {
            if (!r.m_5818_(new FakeContainer(itemEntity.m_32055_()), level) || !r.powerMet(crucible, level)) continue;
            ItemStack result = r.apply(itemEntity.m_32055_(), crucible, level);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.6, (double)pos.m_123343_() + 0.5, result));
            crucible.setDirty(level, pos, state);
            return true;
        }
        return false;
    }

    private static boolean tryPrecipitate(Level level, BlockPos pos, BlockState state, CrucibleBlockEntity crucible) {
        List creation_recipes = level.m_7465_().m_44013_((RecipeType)Registration.PRECIPITATE_RECIPE_TYPE.get());
        for (PrecipitateRecipe r : creation_recipes) {
            if (!r.powerMet(crucible, level)) continue;
            ItemStack result = r.apply(crucible, level);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, result));
            crucible.setDirty(level, pos, state);
            return true;
        }
        return false;
    }

    @Override
    public void setDirty() {
        this.setDirty(Objects.requireNonNull(this.m_58904_()), this.m_58899_(), this.m_58900_());
    }

    public void beHitByLightning() {
        this.electricCharge = 50;
        this.setDirty();
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (this.m_58904_() == null || !((Boolean)this.m_58900_().m_61143_((Property)CrucibleBlock.FULL)).booleanValue() || event.getEntity().f_19853_.f_46443_ || Objects.requireNonNull(this.m_58904_()).f_46443_) {
            return;
        }
        double dist = BeamHelper.distance(event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_());
        if (dist > (double)((Integer)ConfigMan.COMMON.crucibleRange.get()).intValue() || this.areaMemory.exists(event.getEntity().f_19853_, (Integer)ConfigMan.COMMON.crucibleRange.get(), (Block)Registration.IRON_SYMBOL.get())) {
            return;
        }
        if (((LivingEntity)event.getEntity()).m_6336_().equals(MobType.f_21641_)) {
            this.addPower((Power)Powers.CURSE_POWER.get(), WorldSpecificValue.get("undead_curse_strength", 30, 300));
            return;
        }
        ++this.sacrificeCount;
        FlagCriterion.triggerForNearbyPlayers((ServerLevel)event.getEntity().f_19853_, CriteriaTriggers.SEE_SACRIFICE_TRIGGER, this.m_58899_(), 8);
        double x = event.getEntity().m_20185_();
        double y = event.getEntity().m_20186_();
        double z = event.getEntity().m_20189_();
        if (this.getPowerLevel((Power)Powers.CURSE_POWER.get()) >= WorldSpecificValues.CURSE_RATE.get() && this.getPowerLevel((Power)Powers.MIND_POWER.get()) > 0 && !(event.getEntity() instanceof Phantom) && event.getEntity().m_183503_().m_46462_()) {
            this.spawnPhantom(x, y, z);
        } else {
            ParticleScribe.drawParticleLine(this.f_58857_, (ParticleOptions)ParticleTypes.f_123796_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.4, (double)this.m_58899_().m_123343_() + 0.5, x, y, z, 15, 0.3);
        }
        int best_sacrifice_type = WorldSpecificValues.BEST_SACRIFICE.get();
        int power = best_sacrifice_type == 1 && event.getEntity() instanceof Animal ? WorldSpecificValue.get("strong_sacrifice", 300, 600) : (best_sacrifice_type == 2 && event.getEntity() instanceof AbstractVillager ? WorldSpecificValue.get("strong_sacrifice", 300, 600) : (best_sacrifice_type == 3 && (event.getEntity() instanceof AbstractPiglin || event.getEntity() instanceof Hoglin) ? WorldSpecificValue.get("strong_sacrifice", 300, 600) : (best_sacrifice_type == 4 && event.getEntity() instanceof Monster ? WorldSpecificValue.get("strong_sacrifice", 300, 600) : WorldSpecificValue.get("weak_sacrifice", 30, 60))));
        this.addPower((Power)Powers.VITAL_POWER.get(), power);
        this.setDirty();
    }

    private void spawnPhantom(double x, double y, double z) {
        Phantom p = new Phantom(EntityType.f_20509_, Objects.requireNonNull(this.m_58904_()));
        p.m_146884_(new Vec3(x, y + 2.0, z));
        p.m_33108_(this.m_58904_().f_46441_.nextInt(1, 4));
        this.m_58904_().m_7967_((Entity)p);
        ParticleScribe.drawParticleLine(this.f_58857_, (ParticleOptions)ParticleTypes.f_123762_, x, y, z, x, y + 2.0, z, 25, 0.1);
    }

    @Override
    @NotNull
    public Map<Power, Integer> getPowerMap() {
        return this.powers;
    }

    public void setDirty(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_) {
            this.m_6596_();
            level.m_7260_(pos, state, state, 2);
        }
    }

    @Override
    public boolean addPower(Power p, int amount) {
        int prev;
        if (p == null) {
            return false;
        }
        if (this.getPowerLevel(p) == 1600) {
            return false;
        }
        if (this.getTotalPowerLevel() + amount > 1600) {
            int excess = this.getTotalPowerLevel() + amount - 1600;
            this.expendAnyPowerExcept(p, excess);
            excess = this.getTotalPowerLevel() + amount - 1600;
            if (excess > 0) {
                amount -= excess;
            }
        }
        if ((prev = this.powers.getOrDefault(p, 0).intValue()) > 0) {
            this.powers.replace(p, amount + prev);
        } else {
            this.powers.put(p, amount);
        }
        return true;
    }

    @Override
    public int getPowerLevel(Power t) {
        if (this.powers.isEmpty() || this.powers.get(t) == null) {
            return 0;
        }
        return this.powers.get(t);
    }

    @Override
    public boolean expendPower(Power t, int amount) {
        if (this.powers.isEmpty() || !this.powers.containsKey(t)) {
            return false;
        }
        int level = this.powers.get(t);
        if (level > amount) {
            this.powers.put(t, level - amount);
            return true;
        }
        if (level == amount) {
            this.powers.put(t, 0);
            return true;
        }
        this.powers.put(t, 0);
        return false;
    }

    @Override
    public void expendAnyPowerExcept(Power immune_power, int amount) {
        boolean expended = false;
        for (Power p : this.powers.keySet()) {
            if (p != immune_power && p != Powers.CURSE_POWER.get()) {
                expended = this.expendPower(p, amount);
            }
            if (!expended) continue;
            return;
        }
    }

    @Override
    public void expendPower() {
        this.powers.clear();
        this.color_changed = true;
        this.mix_color.reset();
        this.next_mix_color.reset();
        this.color_initialized = false;
    }

    @Override
    public int getTotalPowerLevel() {
        int totalpp = 0;
        if (this.powers == null) {
            return 0;
        }
        for (Power p : this.powers.keySet()) {
            totalpp += this.powers.get(p).intValue();
        }
        return totalpp;
    }

    @Override
    public Color getCombinedColor(int water_color_number) {
        Color water_color = new Color(water_color_number);
        if (this.powers == null || this.powers.isEmpty() || this.getTotalPowerLevel() == 0) {
            return water_color;
        }
        if (this.color_changed) {
            this.updateColor(water_color);
        }
        if (!this.color_initialized) {
            this.mix_color.red = water_color.red;
            this.mix_color.green = water_color.green;
            this.mix_color.blue = water_color.blue;
            this.color_initialized = true;
        }
        if (!this.mix_color.equals(this.next_mix_color)) {
            int delta_red = Math.min(Math.abs(this.next_mix_color.red - this.mix_color.red), 2);
            int delta_green = Math.min(Math.abs(this.next_mix_color.green - this.mix_color.green), 2);
            int delta_blue = Math.min(Math.abs(this.next_mix_color.blue - this.mix_color.blue), 2);
            this.mix_color.red = this.next_mix_color.red > this.mix_color.red ? this.mix_color.red + delta_red : this.mix_color.red - delta_red;
            this.mix_color.green = this.next_mix_color.green > this.mix_color.green ? this.mix_color.green + delta_green : this.mix_color.green - delta_green;
            this.mix_color.blue = this.next_mix_color.blue > this.mix_color.blue ? this.mix_color.blue + delta_blue : this.mix_color.blue - delta_blue;
        }
        return this.mix_color;
    }

    private void updateColor(Color water_color) {
        if (this.powers == null) {
            return;
        }
        this.next_mix_color.reset();
        for (Power p : this.powers.keySet()) {
            if (p == null) continue;
            Color pow_color = p.getColor();
            float pow_weight = (float)this.getPowerLevel(p) / (float)this.getTotalPowerLevel();
            this.next_mix_color.red = (int)((float)this.next_mix_color.red + (float)pow_color.red * pow_weight);
            this.next_mix_color.green = (int)((float)this.next_mix_color.green + (float)pow_color.green * pow_weight);
            this.next_mix_color.blue = (int)((float)this.next_mix_color.blue + (float)pow_color.blue * pow_weight);
        }
        float tint_alpha = (float)this.getTotalPowerLevel() / 1600.0f;
        this.next_mix_color.red = (int)((float)water_color.red * (1.0f - tint_alpha) + (float)this.next_mix_color.red * tint_alpha);
        this.next_mix_color.green = (int)((float)water_color.green * (1.0f - tint_alpha) + (float)this.next_mix_color.green * tint_alpha);
        this.next_mix_color.blue = (int)((float)water_color.blue * (1.0f - tint_alpha) + (float)this.next_mix_color.blue * tint_alpha);
        this.color_changed = false;
    }

    private void resetColor() {
        this.color_changed = true;
        this.color_initialized = false;
        this.mix_color.reset();
        this.next_mix_color.reset();
    }

    public float getOpacity() {
        return 0.7f + 0.3f * (float)this.getTotalPowerLevel() / 1600.0f;
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.color_changed = true;
    }

    protected void m_183515_(@NotNull CompoundTag main_tag) {
        super.m_183515_(main_tag);
        main_tag.m_128365_("electric_charge", (Tag)IntTag.m_128679_((int)this.electricCharge));
        if (this.linked_crystal != null) {
            main_tag.m_128365_("LinkedCrystal", (Tag)IntTag.m_128679_((int)this.linked_crystal.m_142049_()));
        }
        if (this.powers == null || this.powers.isEmpty()) {
            return;
        }
        ListTag power_list_tag = new ListTag();
        for (Power p : this.powers.keySet()) {
            if (p == null) {
                System.err.println("Skipping null power in save process.");
                continue;
            }
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("name", (Tag)StringTag.m_129297_((String)p.getId()));
            tag.m_128365_("level", (Tag)IntTag.m_128679_((int)this.getPowerLevel(p)));
            power_list_tag.add((Object)tag);
        }
        main_tag.m_128365_("powers", (Tag)power_list_tag);
    }

    public void m_142466_(@NotNull CompoundTag main_tag) {
        super.m_142466_(main_tag);
        if (main_tag.m_128441_("LinkedCrystal")) {
            int crystal_id = main_tag.m_128451_("LinkedCrystal");
            if (this.f_58857_.m_6815_(crystal_id) instanceof EndCrystal) {
                this.linked_crystal = (EndCrystal)this.f_58857_.m_6815_(crystal_id);
            }
        } else {
            this.linked_crystal = null;
        }
        ListTag power_list_tag = (ListTag)main_tag.m_128423_("powers");
        this.powers.clear();
        if (power_list_tag != null && !power_list_tag.isEmpty()) {
            for (Tag power_tag : power_list_tag) {
                Power p = Power.readPower((CompoundTag)power_tag);
                this.addPower(p, ((CompoundTag)power_tag).m_128451_("level"));
            }
        }
        this.electricCharge = main_tag.m_128451_("electric_charge");
    }
}

