/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.blocks;

import com.hyperlynx.reactive.be.SymbolBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SymbolBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private Item symbol_item = Items.f_42127_;
    protected static final VoxelShape UP_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)1.0, (double)14.0);
    protected static final VoxelShape DOWN_SHAPE = Block.m_49796_((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)1.0, (double)14.0, (double)14.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)15.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)2.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0, (double)16.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)1.0);

    public SymbolBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.UP));
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (((Direction)state.m_61143_((Property)FACING)).equals((Object)Direction.UP)) {
            return UP_SHAPE;
        }
        if (((Direction)state.m_61143_((Property)FACING)).equals((Object)Direction.DOWN)) {
            return DOWN_SHAPE;
        }
        if (((Direction)state.m_61143_((Property)FACING)).equals((Object)Direction.EAST)) {
            return EAST_SHAPE;
        }
        if (((Direction)state.m_61143_((Property)FACING)).equals((Object)Direction.WEST)) {
            return WEST_SHAPE;
        }
        if (((Direction)state.m_61143_((Property)FACING)).equals((Object)Direction.NORTH)) {
            return NORTH_SHAPE;
        }
        if (((Direction)state.m_61143_((Property)FACING)).equals((Object)Direction.SOUTH)) {
            return SOUTH_SHAPE;
        }
        System.err.println("Missing block state information for a symbol block at " + pos + "?!!");
        return UP_SHAPE;
    }

    public void setSymbolItem(Item item) {
        this.symbol_item = item;
    }

    @NotNull
    public Item m_5456_() {
        return this.symbol_item;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        SymbolBlockEntity symbol = new SymbolBlockEntity(pos, state, this.symbol_item);
        symbol.setFacing(FACING.m_6215_("facing").orElse(Direction.UP));
        return symbol;
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.INVISIBLE;
    }
}

