/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.fx;

import com.hyperlynx.reactive.ReactiveMod;
import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.Powers;
import com.hyperlynx.reactive.alchemy.rxn.Reaction;
import com.hyperlynx.reactive.be.CrucibleBlockEntity;
import com.hyperlynx.reactive.blocks.CrucibleBlock;
import com.hyperlynx.reactive.fx.ParticleScribe;
import com.hyperlynx.reactive.util.Color;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.jetbrains.annotations.NotNull;

public class CrucibleRenderer
implements BlockEntityRenderer<CrucibleBlockEntity> {
    private final BlockRenderDispatcher blockRenderDispatcher;

    public CrucibleRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderDispatcher = context.m_173584_();
    }

    private TextureAtlasSprite getSprite(CrucibleBlockEntity crucible) {
        int threshold = 800;
        if (crucible.getPowerLevel((Power)Powers.CURSE_POWER.get()) + crucible.getPowerLevel((Power)Powers.WARP_POWER.get()) + crucible.getPowerLevel((Power)Powers.Z_POWER.get()) > threshold) {
            return this.blockRenderDispatcher.m_110910_(((Block)Registration.DUMMY_NOISE_WATER.get()).m_49966_()).getParticleIcon((IModelData)EmptyModelData.INSTANCE);
        }
        if (crucible.getPowerLevel((Power)Powers.MIND_POWER.get()) + crucible.getPowerLevel((Power)Powers.LIGHT_POWER.get()) + crucible.getPowerLevel((Power)Powers.Y_POWER.get()) > threshold) {
            return this.blockRenderDispatcher.m_110910_(((Block)Registration.DUMMY_MAGIC_WATER.get()).m_49966_()).getParticleIcon((IModelData)EmptyModelData.INSTANCE);
        }
        if (crucible.getPowerLevel((Power)Powers.SOUL_POWER.get()) + crucible.getPowerLevel((Power)Powers.X_POWER.get()) > threshold) {
            return this.blockRenderDispatcher.m_110910_(((Block)Registration.DUMMY_FAST_WATER.get()).m_49966_()).getParticleIcon((IModelData)EmptyModelData.INSTANCE);
        }
        return this.blockRenderDispatcher.m_110910_(Blocks.f_49990_.m_49966_()).getParticleIcon((IModelData)EmptyModelData.INSTANCE);
    }

    private void renderReactions(CrucibleBlockEntity crucible) {
        for (Reaction r : ReactiveMod.REACTION_MAN.getReactions()) {
            if (!r.conditionsMet(crucible)) continue;
            r.render(crucible.m_58904_(), crucible);
        }
    }

    private void renderElectricity(CrucibleBlockEntity crucible) {
        float speedDivisor = 27.0f;
        if (crucible.electricCharge > 0) {
            ParticleScribe.drawParticleCrucibleTop(Objects.requireNonNull(crucible.m_58904_()), (ParticleOptions)ParticleTypes.f_175830_, crucible.m_58899_(), 0.05f, ((double)crucible.m_58904_().f_46441_.nextFloat() - 0.5) / (double)speedDivisor, ((double)crucible.m_58904_().f_46441_.nextFloat() - 0.5) / (double)speedDivisor, ((double)crucible.m_58904_().f_46441_.nextFloat() - 0.5) / (double)speedDivisor);
        }
    }

    public void render(@NotNull CrucibleBlockEntity crucible, float partialTicks, PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.5625, 0.0);
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        if (((Boolean)crucible.m_58900_().m_61143_((Property)CrucibleBlock.FULL)).booleanValue()) {
            TextureAtlasSprite sprite = this.getSprite(crucible);
            Color color = crucible.getCombinedColor(BiomeColors.m_108811_((BlockAndTintGetter)((BlockAndTintGetter)Objects.requireNonNull(crucible.m_58904_())), (BlockPos)crucible.m_58899_()));
            VertexConsumer buffer = bufferSource.m_6299_(Sheets.m_110792_());
            CrucibleRenderer.renderIcon(poseStack, buffer, sprite, color, crucible.getOpacity(), combinedOverlay, combinedLight);
        }
        poseStack.m_85849_();
        this.renderReactions(crucible);
        this.renderElectricity(crucible);
    }

    public static void renderIcon(PoseStack ms, VertexConsumer builder, TextureAtlasSprite sprite, Color color, float alpha, int overlay, int light) {
        Matrix4f mat = ms.m_85850_().m_85861_();
        builder.m_85982_(mat, 0.2f, 0.8f, 0.0f).m_6122_(color.red, color.green, color.blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118409_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(mat, 0.8f, 0.8f, 0.0f).m_6122_(color.red, color.green, color.blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118410_(), sprite.m_118412_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(mat, 0.8f, 0.2f, 0.0f).m_6122_(color.red, color.green, color.blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118410_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
        builder.m_85982_(mat, 0.2f, 0.2f, 0.0f).m_6122_(color.red, color.green, color.blue, (int)(alpha * 255.0f)).m_7421_(sprite.m_118409_(), sprite.m_118411_()).m_86008_(overlay).m_85969_(light).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
    }
}

