/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.items;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.alchemy.Powers;
import com.hyperlynx.reactive.alchemy.WorldSpecificValues;
import com.hyperlynx.reactive.be.CrucibleBlockEntity;
import com.hyperlynx.reactive.items.WarpBottleItem;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class PowerBottleItem
extends Item {
    public static final int BOTTLE_COST = 600;
    private static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = new DispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior();

        public ItemStack m_6115_(BlockSource source, ItemStack stack) {
            BlockPos target = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
            if (!source.m_7727_().m_8055_(target).m_60713_((Block)Registration.CRUCIBLE.get())) {
                return this.defaultDispenseItemBehavior.m_6115_(source, stack);
            }
            CrucibleBlockEntity crucible = (CrucibleBlockEntity)source.m_7727_().m_7702_(target);
            if (crucible == null) {
                return this.defaultDispenseItemBehavior.m_6115_(source, stack);
            }
            boolean changed = false;
            for (Power p : Powers.POWER_SUPPLIER.get()) {
                if (!p.matchesBottle(stack) || !crucible.addPower(p, WorldSpecificValues.BOTTLE_RETURN.get())) continue;
                if (stack.m_150930_((Item)Registration.WARP_BOTTLE.get()) && WarpBottleItem.isRiftBottle(stack)) {
                    crucible.enderRiftStrength = 2000;
                }
                stack.m_41774_(1);
                ItemEntity quartz_bottle_drop = new ItemEntity((Level)source.m_7727_(), (double)target.m_123341_() + 0.5, (double)target.m_123342_() + 0.6, (double)target.m_123343_() + 0.5, ((Item)Registration.QUARTZ_BOTTLE.get()).m_7968_());
                source.m_7727_().m_7967_((Entity)quartz_bottle_drop);
                changed = true;
            }
            if (changed) {
                crucible.setDirty();
                crucible.m_58904_().m_5594_(null, crucible.m_58899_(), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.65f + crucible.m_58904_().m_5822_().nextFloat() / 5.0f);
            }
            return stack;
        }
    };

    public PowerBottleItem(Item.Properties props) {
        super(props);
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)DISPENSE_ITEM_BEHAVIOR);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().m_8055_(context.m_8083_()).m_60713_((Block)Registration.CRUCIBLE.get())) {
            return InteractionResult.PASS;
        }
        CrucibleBlockEntity crucible = (CrucibleBlockEntity)context.m_43725_().m_7702_(context.m_8083_());
        if (crucible == null) {
            return InteractionResult.PASS;
        }
        boolean changed = false;
        for (Power p : Powers.POWER_SUPPLIER.get()) {
            if (!p.matchesBottle(context.m_43722_()) || !crucible.addPower(p, WorldSpecificValues.BOTTLE_RETURN.get())) continue;
            if (context.m_43722_().m_150930_((Item)Registration.WARP_BOTTLE.get()) && WarpBottleItem.isRiftBottle(context.m_43722_())) {
                crucible.enderRiftStrength = 2000;
            }
            if (context.m_43722_().m_41613_() == 1) {
                Objects.requireNonNull(context.m_43723_()).m_21008_(context.m_43724_(), ((Item)Registration.QUARTZ_BOTTLE.get()).m_7968_());
            } else {
                Objects.requireNonNull(context.m_43723_()).m_21120_(context.m_43724_()).m_41774_(1);
                context.m_43723_().m_36356_(((Item)Registration.QUARTZ_BOTTLE.get()).m_7968_());
            }
            changed = true;
        }
        if (changed) {
            crucible.setDirty();
            crucible.m_58904_().m_5594_(null, crucible.m_58899_(), SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 0.65f + crucible.m_58904_().m_5822_().nextFloat() / 5.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public static void tryEmptyPowerBottle(ItemEntity e, CrucibleBlockEntity c) {
        boolean changed = false;
        for (Power p : Powers.POWER_SUPPLIER.get()) {
            if (!p.matchesBottle(e.m_32055_()) || !c.addPower(p, WorldSpecificValues.BOTTLE_RETURN.get())) continue;
            if (e.m_32055_().m_150930_((Item)Registration.WARP_BOTTLE.get()) && WarpBottleItem.isRiftBottle(e.m_32055_())) {
                c.enderRiftStrength = 2000;
            }
            if (e.m_32055_().m_41613_() == 1) {
                e.m_32045_(((Item)Registration.QUARTZ_BOTTLE.get()).m_7968_());
            } else {
                e.m_32055_().m_41774_(1);
                ItemEntity empty_bottle = new ItemEntity(c.m_58904_(), e.m_20185_(), e.m_20186_(), e.m_20189_(), ((Item)Registration.QUARTZ_BOTTLE.get()).m_7968_());
                e.m_183503_().m_7967_((Entity)empty_bottle);
            }
            changed = true;
        }
        if (changed) {
            c.setDirty();
            c.m_58904_().m_5594_(null, c.m_58899_(), SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 0.65f + c.m_58904_().m_5822_().nextFloat() / 5.0f);
        }
    }
}

