/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.items;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.fx.ParticleScribe;
import com.hyperlynx.reactive.util.BeamHelper;
import com.hyperlynx.reactive.util.HarvestChecker;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class StaffEffects {
    public static Player radiance(Player user) {
        Vec3 end;
        BlockHitResult blockHit = BeamHelper.playerRayTrace(user.f_19853_, user, ClipContext.Fluid.NONE, ClipContext.Block.VISUAL, 32.0);
        Vec3 blockHitPos = blockHit.m_82450_();
        Vec3 start = user.m_146892_();
        EntityHitResult entityHit = ProjectileUtil.m_37287_((Entity)user, (Vec3)start, (Vec3)(end = start.m_82549_(user.m_20154_().m_82490_(32.0))), (AABB)new AABB(start, end), e -> e instanceof LivingEntity, (double)Double.MAX_VALUE);
        Vec3 beam_end = entityHit == null ? blockHitPos : (entityHit.m_82450_().m_82557_(start) < blockHitPos.m_82557_(start) ? entityHit.m_82450_() : blockHitPos);
        if (user instanceof ServerPlayer) {
            Entity entity;
            if (entityHit != null && (entity = entityHit.m_82443_()) instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)entity;
                if (victim.m_6336_().equals(MobType.f_21641_)) {
                    victim.m_7311_(300);
                    victim.m_6469_(DamageSource.m_19344_((Player)user).m_146708_(), 7.0f);
                }
                victim.m_6469_(DamageSource.m_19344_((Player)user).m_19389_(), 3.0f);
            }
        } else {
            ParticleScribe.drawParticleLine(user.f_19853_, (ParticleOptions)ParticleTypes.f_123810_, user.m_146892_().f_82479_, user.m_146892_().f_82480_ - 0.4, user.m_146892_().f_82481_, beam_end.f_82479_, beam_end.f_82480_, beam_end.f_82481_, 2, 0.1);
        }
        return user;
    }

    public static Player blazing(Player user) {
        BlockHitResult blockHit = BeamHelper.playerRayTrace(user.f_19853_, user, ClipContext.Fluid.NONE, ClipContext.Block.COLLIDER, 16.0);
        Vec3 blockHitPos = blockHit.m_82450_();
        Vec3 start = user.m_146892_();
        start = start.m_82520_(0.0, -0.3, 0.0);
        if (user instanceof ServerPlayer) {
            AABB aoe = new AABB(start, blockHitPos);
            for (LivingEntity victim : user.f_19853_.m_45976_(LivingEntity.class, aoe)) {
                if (victim.equals((Object)user)) continue;
                victim.m_7311_(1000);
                victim.m_6469_(DamageSource.m_19344_((Player)user).m_19383_(), 1.0f);
            }
            if (user.f_19853_.m_8055_(blockHit.m_82425_().m_7494_()).m_60795_()) {
                user.f_19853_.m_46597_(blockHit.m_82425_().m_7494_(), Blocks.f_50083_.m_49966_());
            }
        } else {
            ParticleScribe.drawParticleStream(user.f_19853_, (ParticleOptions)ParticleTypes.f_123744_, start, user.m_20154_(), 5);
        }
        return user;
    }

    public static Player spectral(Player user) {
        BlockHitResult blockHit = BeamHelper.playerRayTrace(user.f_19853_, user, ClipContext.Fluid.NONE, ClipContext.Block.COLLIDER, 16.0);
        Vec3 blockHitPos = blockHit.m_82450_();
        if (user instanceof ServerPlayer) {
            AABB aoe = new AABB(blockHitPos.m_82492_(1.0, 1.0, 1.0), blockHitPos.m_82520_(1.0, 1.0, 1.0));
            aoe = aoe.m_82400_(2.0);
            for (LivingEntity victim : user.f_19853_.m_45976_(LivingEntity.class, aoe)) {
                if (victim instanceof ServerPlayer) continue;
                victim.m_6469_(DamageSource.f_19318_, 3.0f);
                victim.m_147240_(0.3, user.f_19853_.f_46441_.nextDouble() * 0.2 - 0.1, user.f_19853_.f_46441_.nextDouble() * 0.2 - 0.1);
            }
        } else {
            user.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123746_, blockHitPos.f_82479_, blockHitPos.f_82480_, blockHitPos.f_82481_, 0.0, 0.0, 0.0);
        }
        return user;
    }

    public static Player warping(Player user) {
        Vec3 end;
        BlockHitResult blockHit = BeamHelper.playerRayTrace(user.f_19853_, user, ClipContext.Fluid.NONE, ClipContext.Block.OUTLINE, 16.0);
        Vec3 blockHitPos = blockHit.m_82450_();
        Vec3 start = user.m_146892_();
        EntityHitResult entityHit = ProjectileUtil.m_37287_((Entity)user, (Vec3)start, (Vec3)(end = start.m_82549_(user.m_20154_().m_82490_(16.0))), (AABB)new AABB(start, end), Objects::nonNull, (double)Double.MAX_VALUE);
        Vec3 beam_end = entityHit == null ? blockHitPos : (entityHit.m_82450_().m_82557_(start) < blockHitPos.m_82557_(start) ? entityHit.m_82450_() : blockHitPos);
        if (user instanceof ServerPlayer) {
            BlockState hit_state = user.f_19853_.m_8055_(blockHit.m_82425_());
            if (entityHit != null) {
                Entity entity = entityHit.m_82443_();
                if (entity instanceof LivingEntity) {
                    LivingEntity victim = (LivingEntity)entity;
                    victim.m_6469_(DamageSource.m_19344_((Player)user).m_19389_(), 5.0f);
                }
                if ((entity = entityHit.m_82443_()) instanceof ItemEntity) {
                    ItemEntity drop_entity = (ItemEntity)entity;
                    drop_entity.m_6021_(user.m_20185_(), user.m_20186_(), user.m_20189_());
                }
            } else if (HarvestChecker.canMineBlock(user.f_19853_, user, blockHit.m_82425_(), user.f_19853_.m_8055_(blockHit.m_82425_()), 30.0f)) {
                hit_state.m_60734_().m_5707_(user.f_19853_, blockHit.m_82425_(), hit_state, user);
                hit_state.m_60734_().m_6240_(user.f_19853_, user, blockHit.m_82425_(), hit_state, null, Items.f_42385_.m_7968_());
                user.f_19853_.m_7471_(blockHit.m_82425_(), false);
            }
        } else {
            ParticleScribe.drawParticleZigZag(user.f_19853_, (ParticleOptions)ParticleTypes.f_123808_, user.m_146892_().f_82479_, user.m_146892_().f_82480_ - 0.4, user.m_146892_().f_82481_, beam_end.f_82479_, beam_end.f_82480_, beam_end.f_82481_, 4, 4, 0.1);
        }
        return user;
    }

    public static Player missile(Player user) {
        if (user instanceof ServerPlayer) {
            AABB aoe = new AABB(user.m_20182_().m_82492_(1.0, 1.0, 1.0), user.m_20182_().m_82520_(1.0, 1.0, 1.0));
            aoe = aoe.m_82400_(7.0);
            List nearby_ents = user.m_183503_().m_45976_(LivingEntity.class, aoe);
            nearby_ents.remove(user);
            for (int i = 0; i < 3 && !nearby_ents.isEmpty(); ++i) {
                LivingEntity victim = (LivingEntity)nearby_ents.get(user.f_19853_.f_46441_.nextInt(0, nearby_ents.size()));
                victim.m_6469_(DamageSource.m_19344_((Player)user).m_19389_(), 3.0f);
                ParticleScribe.drawParticleZigZag(user.f_19853_, (ParticleOptions)Registration.SMALL_RUNE_PARTICLE, user.m_20185_(), user.m_20188_() - 0.4, user.m_20189_(), victim.m_20185_(), victim.m_20188_(), victim.m_20189_(), 2, 5, 0.7);
            }
        }
        return user;
    }

    public static Player living(Player user) {
        if ((double)user.m_183503_().f_46441_.nextFloat() < 0.4) {
            AABB aoe = new AABB(user.m_20182_().m_82492_(1.0, 1.0, 1.0), user.m_20182_().m_82520_(1.0, 1.0, 1.0));
            aoe = aoe.m_82400_(5.0);
            List nearby_ents = user.m_183503_().m_45976_(LivingEntity.class, aoe);
            for (LivingEntity victim : nearby_ents) {
                victim.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 30, 1));
            }
        }
        for (int i = 0; i < 10; ++i) {
            user.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123784_, user.m_20208_(5.0), user.m_20186_(), user.m_20262_(5.0), 0.0, 0.0, 0.0);
        }
        return user;
    }
}

