/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.hyperlynx.reactive.recipes.DissolveRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DissolveRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<DissolveRecipe> {
    ResourceLocation name;

    @NotNull
    public DissolveRecipe fromJson(@NotNull ResourceLocation id, JsonObject json) {
        try {
            ItemStack reactant = CraftingHelper.getItemStack((JsonObject)json.get("reactant").getAsJsonObject(), (boolean)false);
            ItemStack product = CraftingHelper.getItemStack((JsonObject)json.get("product").getAsJsonObject(), (boolean)false);
            return new DissolveRecipe(id, "dissolve", reactant, product);
        }
        catch (JsonSyntaxException e) {
            return DissolveRecipe.EMPTY;
        }
    }

    @Nullable
    public DissolveRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buffer) {
        ItemStack reactant = buffer.m_130267_();
        ItemStack product = buffer.m_130267_();
        return new DissolveRecipe(id, "dissolve", reactant, product);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull DissolveRecipe recipe) {
        buffer.m_130055_(recipe.reactant);
        buffer.m_130055_(recipe.product);
    }
}

