/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.recipes.jei;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.recipes.jei.DissolveRecipeCategory;
import com.hyperlynx.reactive.recipes.jei.TransmuteRecipeCategory;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ReactiveJEIPlugin
implements IModPlugin {
    public static IJeiHelpers HELPERS;
    public static DissolveRecipeCategory DISSOLVE_CATEGORY;
    public static TransmuteRecipeCategory TRANSMUTE_CATEGORY;

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("reactive", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{DISSOLVE_CATEGORY});
        registration.addRecipeCategories(new IRecipeCategory[]{TRANSMUTE_CATEGORY});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        HELPERS = registration.getJeiHelpers();
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        registration.addRecipes(DISSOLVE_CATEGORY.getRecipeType(), level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)Registration.DISSOLVE_RECIPE_TYPE.get()));
        registration.addRecipes(TRANSMUTE_CATEGORY.getRecipeType(), level.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)Registration.TRANS_RECIPE_TYPE.get()));
        this.addDescriptions(registration);
    }

    private void addDescriptions(IRecipeRegistration registration) {
        registration.addItemStackInfo(((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_(), new Component[]{new TranslatableComponent("jei.reactive.crucible")});
        registration.addItemStackInfo(((Item)Registration.SALT.get()).m_7968_(), new Component[]{new TranslatableComponent("jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)Registration.GOLD_FOAM_ITEM.get()).m_7968_(), new Component[]{new TranslatableComponent("jei.reactive.reaction_result")});
        registration.addItemStackInfo(((Item)Registration.MOTION_SALT.get()).m_7968_(), new Component[]{new TranslatableComponent("jei.reactive.reaction_result")});
        this.addGenericDescriptions(registration, (Item)Registration.STAFF_OF_WARP_ITEM.get(), (Item)Registration.STAFF_OF_MIND_ITEM.get(), (Item)Registration.STAFF_OF_BLAZE_ITEM.get(), (Item)Registration.STAFF_OF_LIFE_ITEM.get(), (Item)Registration.STAFF_OF_LIGHT_ITEM.get(), (Item)Registration.STAFF_OF_SOUL_ITEM.get(), (Item)Registration.SOLID_PORTAL_ITEM.get(), (Item)Registration.LIGHT_BOTTLE.get(), (Item)Registration.MIND_BOTTLE.get(), (Item)Registration.BODY_BOTTLE.get(), (Item)Registration.WARP_BOTTLE.get(), (Item)Registration.BLAZE_BOTTLE.get(), (Item)Registration.ACID_BOTTLE.get(), (Item)Registration.VERDANT_BOTTLE.get(), (Item)Registration.SOUL_BOTTLE.get());
    }

    private void addGenericDescriptions(IRecipeRegistration registration, Item ... items) {
        for (Item item : items) {
            registration.addItemStackInfo(item.m_7968_(), new Component[]{new TranslatableComponent("jei.reactive.generic")});
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_(), new RecipeType[]{DISSOLVE_CATEGORY.getRecipeType()});
        registration.addRecipeCatalyst(((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_(), new RecipeType[]{TRANSMUTE_CATEGORY.getRecipeType()});
    }

    static {
        DISSOLVE_CATEGORY = new DissolveRecipeCategory();
        TRANSMUTE_CATEGORY = new TransmuteRecipeCategory();
    }
}

