/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.recipes.jei;

import com.hyperlynx.reactive.Registration;
import com.hyperlynx.reactive.alchemy.Power;
import com.hyperlynx.reactive.recipes.TransmuteRecipe;
import com.hyperlynx.reactive.recipes.jei.ReactiveJEIPlugin;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class TransmuteRecipeCategory
implements IRecipeCategory<TransmuteRecipe> {
    @Nullable
    public ResourceLocation getRegistryName(TransmuteRecipe recipe) {
        return new ResourceLocation("reactive", "transmute");
    }

    public ResourceLocation getUid() {
        return new ResourceLocation("reactive", "transmute");
    }

    public Class<? extends TransmuteRecipe> getRecipeClass() {
        return TransmuteRecipe.class;
    }

    public RecipeType<TransmuteRecipe> getRecipeType() {
        return RecipeType.create((String)"reactive", (String)"transmute", TransmuteRecipe.class);
    }

    public Component getTitle() {
        return new TranslatableComponent("title.reactive.transmute");
    }

    public IDrawable getBackground() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawable(new ResourceLocation("reactive", "textures/gui/tf_jei.png"), 2, 2, 76, 49);
    }

    public IDrawable getIcon() {
        return ReactiveJEIPlugin.HELPERS.getGuiHelper().createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)((Item)Registration.CRUCIBLE_ITEM.get()).m_7968_());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TransmuteRecipe recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder input_slot = builder.addSlot(RecipeIngredientRole.INPUT, 1, 1);
        IRecipeSlotBuilder output_slot = builder.addSlot(RecipeIngredientRole.OUTPUT, 60, 1);
        input_slot.setSlotName("reactant");
        input_slot.addItemStack(recipe.getReactant());
        output_slot.setSlotName("product");
        output_slot.addItemStack(recipe.m_8043_());
    }

    public void draw(TransmuteRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        ArrayList<String> reagent_list = new ArrayList<String>();
        for (Power reagent : recipe.getReagents()) {
            reagent_list.add(reagent.getName());
        }
        Minecraft minecraft = Minecraft.m_91087_();
        this.drawReagentLabel(minecraft, stack, ((Object)reagent_list).toString().substring(1, ((Object)reagent_list).toString().length() - 1));
    }

    private void drawReagentLabel(Minecraft minecraft, PoseStack poseStack, String label) {
        int width = minecraft.f_91062_.m_92895_(label);
        int center = this.getBackground().getWidth() / 2;
        int x = center - width / 2;
        int y = 41;
        minecraft.f_91062_.m_92883_(poseStack, label, (float)x, (float)y, 0xFF3838);
    }
}

