/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.util;

import com.hyperlynx.reactive.blocks.WarpSpongeBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class AreaMemory {
    BlockPos hostPos;
    Map<Block, BlockPos> model;

    public AreaMemory(BlockPos hostPos) {
        this.hostPos = hostPos;
        this.model = new HashMap<Block, BlockPos>();
    }

    public boolean exists(Level l, int radius, Block target) {
        return this.fetch(l, radius, target) != null;
    }

    public BlockPos fetch(Level l, int radius, Block target) {
        BlockPos holder;
        if (this.model.containsKey(target) && l.m_8055_(holder = this.model.get(target)).m_60713_(target)) {
            return holder;
        }
        BlockPos newlyFound = this.findAndAddNearest(l, radius, target);
        if (newlyFound != null) {
            this.model.put(target, newlyFound);
        }
        return newlyFound;
    }

    private BlockPos findAndAddNearest(Level l, int radius, Block target) {
        Optional found_maybe = BlockPos.m_121930_((BlockPos)this.hostPos, (int)radius, (int)radius, blockPos -> l.m_8055_(blockPos).m_60713_(target));
        return found_maybe.orElse(null);
    }

    public boolean existsAbove(Level l, int range, Block target) {
        return this.fetchAbove(l, range, target) != null;
    }

    public BlockPos fetchAbove(Level l, int range, Block target) {
        for (int i = 1; i < range; ++i) {
            if (l.m_8055_(this.hostPos.m_6630_(i)).m_60713_(target)) {
                return this.hostPos.m_6630_(i);
            }
            if (!WarpSpongeBlock.stateIsBlocking(l.m_8055_(this.hostPos.m_6630_(i)))) continue;
            return null;
        }
        return null;
    }
}

