/*
 * Decompiled with CFR 0.152.
 */
package com.hyperlynx.reactive.util;

import com.hyperlynx.reactive.Registration;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.extensions.IForgeBlockState;

public class HyperPortalShape {
    private static final BlockBehaviour.StatePredicate FRAME = IForgeBlockState::isPortalFrame;
    private final LevelAccessor level;
    private final Direction.Axis axis;
    private final Direction rightDir;
    private int numPortalBlocks;
    @Nullable
    private BlockPos bottomLeft;
    private int height;
    private final int width;

    private static boolean isEmpty(BlockState state) {
        return state.m_60795_() || state.m_204336_(BlockTags.f_13076_) || state.m_60713_(Blocks.f_50142_) || state.m_60713_((Block)Registration.SOLID_PORTAL.get());
    }

    public void createSolidPortalBlocks() {
        BlockState blockstate = (BlockState)((Block)Registration.SOLID_PORTAL.get()).m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)(this.axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(p_77725_ -> this.level.m_7731_(p_77725_, blockstate, 18));
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public HyperPortalShape(LevelAccessor p_77695_, BlockPos p_77696_, Direction.Axis p_77697_) {
        this.level = p_77695_;
        this.axis = p_77697_;
        this.rightDir = p_77697_ == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.bottomLeft = this.calculateBottomLeft(p_77696_);
        if (this.bottomLeft == null) {
            this.bottomLeft = p_77696_;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.calculateWidth();
            if (this.width > 0) {
                this.height = this.calculateHeight();
            }
        }
    }

    @Nullable
    private BlockPos calculateBottomLeft(BlockPos p_77734_) {
        int i = Math.max(this.level.m_141937_(), p_77734_.m_123342_() - 21);
        while (p_77734_.m_123342_() > i && HyperPortalShape.isEmpty(this.level.m_8055_(p_77734_.m_7495_()))) {
            p_77734_ = p_77734_.m_7495_();
        }
        Direction direction = this.rightDir.m_122424_();
        int j = this.getDistanceUntilEdgeAboveFrame(p_77734_, direction) - 1;
        return j < 0 ? null : p_77734_.m_5484_(direction, j);
    }

    private int calculateWidth() {
        int i = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int getDistanceUntilEdgeAboveFrame(BlockPos p_77736_, Direction p_77737_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= 21; ++i) {
            blockpos$mutableblockpos.m_122190_((Vec3i)p_77736_).m_122175_(p_77737_, i);
            BlockState blockstate = this.level.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (!HyperPortalShape.isEmpty(blockstate)) {
                if (!FRAME.m_61035_(blockstate, (BlockGetter)this.level, (BlockPos)blockpos$mutableblockpos)) break;
                return i;
            }
            BlockState blockstate1 = this.level.m_8055_((BlockPos)blockpos$mutableblockpos.m_122173_(Direction.DOWN));
            if (!FRAME.m_61035_(blockstate1, (BlockGetter)this.level, (BlockPos)blockpos$mutableblockpos)) break;
        }
        return 0;
    }

    private int calculateHeight() {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = this.getDistanceUntilTop(blockpos$mutableblockpos);
        return i >= 3 && i <= 21 && this.hasTopFrame(blockpos$mutableblockpos, i) ? i : 0;
    }

    private boolean hasTopFrame(BlockPos.MutableBlockPos p_77731_, int p_77732_) {
        for (int i = 0; i < this.width; ++i) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = p_77731_.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, p_77732_).m_122175_(this.rightDir, i);
            if (FRAME.m_61035_(this.level.m_8055_((BlockPos)blockpos$mutableblockpos), (BlockGetter)this.level, (BlockPos)blockpos$mutableblockpos)) continue;
            return false;
        }
        return true;
    }

    private int getDistanceUntilTop(BlockPos.MutableBlockPos p_77729_) {
        for (int i = 0; i < 21; ++i) {
            p_77729_.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, -1);
            if (!FRAME.m_61035_(this.level.m_8055_((BlockPos)p_77729_), (BlockGetter)this.level, (BlockPos)p_77729_)) {
                return i;
            }
            p_77729_.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, this.width);
            if (!FRAME.m_61035_(this.level.m_8055_((BlockPos)p_77729_), (BlockGetter)this.level, (BlockPos)p_77729_)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                p_77729_.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, j);
                BlockState blockstate = this.level.m_8055_((BlockPos)p_77729_);
                if (!HyperPortalShape.isEmpty(blockstate)) {
                    return i;
                }
                if (!blockstate.m_60713_(Blocks.f_50142_)) continue;
                ++this.numPortalBlocks;
            }
        }
        return 21;
    }

    public void createPortalBlocks() {
        BlockState blockstate = (BlockState)Blocks.f_50142_.m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)this.axis);
        BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(p_77725_ -> this.level.m_7731_(p_77725_, blockstate, 18));
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }
}

